/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.executor.BulkExecutor;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.operation.BulkOperations;
import org.mule.db.commons.internal.parser.QueryTemplateParser;
import org.mule.db.commons.internal.parser.SimpleQueryTemplateParser;
import org.mule.db.commons.internal.resolver.query.BulkQueryResolver;
import org.mule.db.commons.internal.resolver.query.QueryResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class BulkOperationsTestCase {
    private BulkOperations bulkOperations;
    private QueryResolver<ParameterizedStatementDefinition> mockQueryResolver;
    private BulkQueryResolver mockBulkQueryResolver;
    private QueryTemplateParser mockQueryTemplateParser;
    private Function<ConfigurableStatementFactory, BulkExecutor> mockBulkExecutorSupplier;
    private Function<ConfigurableStatementFactory, QueryExecutor> mockUpdateExecutor;
    private AbstractDbConnector mockConnector;
    private DbConnection mockConnection;
    private StreamingHelper mockStreamingHelper;

    @Before
    public void setUp() {
        this.mockQueryResolver = (QueryResolver)Mockito.mock(QueryResolver.class);
        this.mockBulkQueryResolver = (BulkQueryResolver)Mockito.mock(BulkQueryResolver.class);
        this.mockQueryTemplateParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        this.mockBulkExecutorSupplier = (Function)Mockito.mock(Function.class);
        this.mockUpdateExecutor = (Function)Mockito.mock(Function.class);
        this.mockConnector = (AbstractDbConnector)Mockito.mock(AbstractDbConnector.class);
        this.mockConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockStreamingHelper = (StreamingHelper)Mockito.mock(StreamingHelper.class);
        this.bulkOperations = new BulkOperations.Builder().withQueryResolver(this.mockQueryResolver).withBulkQueryResolver(this.mockBulkQueryResolver).withQueryParser(this.mockQueryTemplateParser).withBulkUpdateExecutor(this.mockBulkExecutorSupplier).withUpdateExecutor(this.mockUpdateExecutor).build();
    }

    @Test
    public void testBuilderWithAllParameters() {
        BulkOperations.Builder builder = new BulkOperations.Builder().withQueryResolver(this.mockQueryResolver).withBulkQueryResolver(this.mockBulkQueryResolver).withQueryParser(this.mockQueryTemplateParser).withBulkUpdateExecutor(this.mockBulkExecutorSupplier).withUpdateExecutor(this.mockUpdateExecutor);
        BulkOperations result = builder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testBuilderWithDefaultValues() {
        BulkOperations.Builder builder = new BulkOperations.Builder();
        BulkOperations result = builder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDefaultBulkQueryResolver() {
        BulkQueryResolver resolver = BulkOperations.getDefaultBulkQueryResolver();
        Assert.assertNotNull((Object)resolver);
    }

    @Test
    public void testGetDefaultQueryTemplateParser() {
        QueryTemplateParser parser = BulkOperations.getDefaultQueryTemplateParser();
        Assert.assertNotNull((Object)parser);
        Assert.assertTrue((boolean)(parser instanceof SimpleQueryTemplateParser));
    }

    @Test
    public void testGetDefaultBulkExecutor() {
        Function executor = BulkOperations.getDefaultBulkExecutor();
        Assert.assertNotNull((Object)executor);
    }
}

