/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.db.commons.api.param.BulkQueryDefinition;
import org.mule.db.commons.api.param.BulkScript;
import org.mule.db.commons.api.param.QuerySettings;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysAttributes;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnIndexAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnNameAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.DefaultAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.NoAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.executor.BulkExecutor;
import org.mule.db.commons.internal.domain.executor.BulkUpdateExecutor;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.executor.UpdateExecutor;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.domain.statement.QueryStatementFactory;
import org.mule.db.commons.internal.domain.statement.StatementFactory;
import org.mule.db.commons.internal.domain.type.CompositeDbTypeManager;
import org.mule.db.commons.internal.operation.BulkOperations;
import org.mule.db.commons.internal.parser.QueryTemplateParser;
import org.mule.db.commons.internal.parser.SimpleQueryTemplateParser;
import org.mule.db.commons.internal.resolver.query.BulkQueryResolver;
import org.mule.db.commons.internal.resolver.query.ParameterizedQueryResolver;
import org.mule.db.commons.internal.resolver.query.QueryResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@RunWith(value=MockitoJUnitRunner.class)
public class BulkOperationsIntegrationTest {
    private static final String DB_URL = "jdbc:h2:mem:bulktestdb_" + UUID.randomUUID().toString().replace("-", "") + ";DB_CLOSE_DELAY=-1";
    private static final String DB_USER = "sa";
    private static final String DB_PASSWORD = "";
    private Connection jdbcConnection;
    private DbConnection dbConnection;
    private BulkOperations bulkOperations;
    private AbstractDbConnector mockConnector;
    private StreamingHelper mockStreamingHelper;

    @Before
    public void setUp() throws SQLException {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("H2 database driver not found. Please ensure h2 dependency is included.", e);
        }
        this.jdbcConnection = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
        this.createTestTable();
        this.dbConnection = new DefaultDbConnection(this.jdbcConnection, Collections.emptyList());
        this.mockConnector = (AbstractDbConnector)Mockito.mock(AbstractDbConnector.class);
        CompositeDbTypeManager typeManager = new CompositeDbTypeManager(Collections.emptyList());
        Mockito.when((Object)this.mockConnector.getTypeManager()).thenReturn((Object)typeManager);
        this.mockStreamingHelper = (StreamingHelper)Mockito.mock(StreamingHelper.class);
        this.bulkOperations = this.createBulkOperations();
    }

    @After
    public void tearDown() throws SQLException {
        if (this.jdbcConnection != null && !this.jdbcConnection.isClosed()) {
            try (Statement stmt = this.jdbcConnection.createStatement();){
                stmt.execute("DROP TABLE IF EXISTS bulk_test_users");
            }
            this.jdbcConnection.close();
        }
    }

    private void createTestTable() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.execute("DROP TABLE IF EXISTS bulk_test_users");
            stmt.execute("CREATE TABLE bulk_test_users (id INT AUTO_INCREMENT PRIMARY KEY,name VARCHAR(100) NOT NULL,email VARCHAR(100) UNIQUE,age INT,status VARCHAR(20) DEFAULT 'active',created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
        }
    }

    private BulkOperations createBulkOperations() {
        ParameterizedQueryResolver queryResolver = new ParameterizedQueryResolver();
        BulkQueryResolver bulkQueryResolver = new BulkQueryResolver();
        QueryStatementFactory statementFactory = new QueryStatementFactory();
        SimpleQueryTemplateParser queryTemplateParser = new SimpleQueryTemplateParser();
        Function<ConfigurableStatementFactory, BulkExecutor> bulkExecutorSupplier = BulkUpdateExecutor::new;
        Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor = factory -> new UpdateExecutor((StatementFactory)factory);
        return new BulkOperations.Builder().withQueryResolver((QueryResolver)queryResolver).withBulkQueryResolver(bulkQueryResolver).withQueryParser((QueryTemplateParser)queryTemplateParser).withBulkUpdateExecutor(bulkExecutorSupplier).withUpdateExecutor(updateExecutor).build();
    }

    private BulkQueryDefinition createBulkInsertQueryDefinition() {
        BulkQueryDefinition queryDef = new BulkQueryDefinition();
        queryDef.setSql("INSERT INTO bulk_test_users (name, email, age) VALUES (:name, :email, :age)");
        return queryDef;
    }

    private BulkQueryDefinition createBulkUpdateQueryDefinition() {
        BulkQueryDefinition queryDef = new BulkQueryDefinition();
        queryDef.setSql("UPDATE bulk_test_users SET age = :age, status = :status WHERE email = :email");
        return queryDef;
    }

    private BulkQueryDefinition createBulkDeleteQueryDefinition() {
        BulkQueryDefinition queryDef = new BulkQueryDefinition();
        queryDef.setSql("DELETE FROM bulk_test_users WHERE email = :email");
        return queryDef;
    }

    private List<Map<String, Object>> createBulkInsertData() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("name", "John Doe");
        row1.put("email", "john@example.com");
        row1.put("age", 30);
        data.add(row1);
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("name", "Jane Smith");
        row2.put("email", "jane@example.com");
        row2.put("age", 25);
        data.add(row2);
        HashMap<String, Object> row3 = new HashMap<String, Object>();
        row3.put("name", "Bob Johnson");
        row3.put("email", "bob@example.com");
        row3.put("age", 35);
        data.add(row3);
        return data;
    }

    private List<Map<String, Object>> createBulkUpdateData() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("age", 31);
        row1.put("status", "updated");
        row1.put("email", "john@example.com");
        data.add(row1);
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("age", 26);
        row2.put("status", "updated");
        row2.put("email", "jane@example.com");
        data.add(row2);
        return data;
    }

    private List<Map<String, Object>> createBulkDeleteData() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HashMap<String, String> row1 = new HashMap<String, String>();
        row1.put("email", "bob@example.com");
        data.add(row1);
        return data;
    }

    private void verifyBulkInsertResults() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        try (Statement stmt = this.jdbcConnection.createStatement();){
            rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((long)3L, (long)rs.getInt(1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT name, email, age FROM bulk_test_users ORDER BY name");
            throwable = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"Bob Johnson", (Object)rs.getString("name"));
                Assert.assertEquals((Object)"bob@example.com", (Object)rs.getString("email"));
                Assert.assertEquals((long)35L, (long)rs.getInt("age"));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"Jane Smith", (Object)rs.getString("name"));
                Assert.assertEquals((Object)"jane@example.com", (Object)rs.getString("email"));
                Assert.assertEquals((long)25L, (long)rs.getInt("age"));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"John Doe", (Object)rs.getString("name"));
                Assert.assertEquals((Object)"john@example.com", (Object)rs.getString("email"));
                Assert.assertEquals((long)30L, (long)rs.getInt("age"));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    private void verifyBulkUpdateResults() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        try (Statement stmt = this.jdbcConnection.createStatement();){
            rs = stmt.executeQuery("SELECT age, status FROM bulk_test_users WHERE email = 'john@example.com'");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((long)31L, (long)rs.getInt("age"));
                Assert.assertEquals((Object)"updated", (Object)rs.getString("status"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT age, status FROM bulk_test_users WHERE email = 'jane@example.com'");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((long)26L, (long)rs.getInt("age"));
                Assert.assertEquals((Object)"updated", (Object)rs.getString("status"));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    private void verifyBulkDeleteResults() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        try (Statement stmt = this.jdbcConnection.createStatement();){
            rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((long)2L, (long)rs.getInt(1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try {
            rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users WHERE email = 'bob@example.com'");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((long)0L, (long)rs.getInt(1));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testBulkInsertOperation() throws SQLException {
        List<Map<String, Object>> bulkData = this.createBulkInsertData();
        BulkQueryDefinition queryDef = this.createBulkInsertQueryDefinition();
        int[] results = this.bulkOperations.bulkInsert(bulkData, queryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)3L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        Assert.assertEquals((long)1L, (long)results[1]);
        Assert.assertEquals((long)1L, (long)results[2]);
        this.verifyBulkInsertResults();
    }

    @Test
    public void testBulkUpdateOperation() throws SQLException {
        List<Map<String, Object>> insertData = this.createBulkInsertData();
        BulkQueryDefinition insertQueryDef = this.createBulkInsertQueryDefinition();
        int[] insertResults = this.bulkOperations.bulkInsert(insertData, insertQueryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        List<Map<String, Object>> updateData = this.createBulkUpdateData();
        BulkQueryDefinition updateQueryDef = this.createBulkUpdateQueryDefinition();
        int[] results = this.bulkOperations.bulkUpdate(updateData, updateQueryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        Assert.assertEquals((long)1L, (long)results[1]);
        this.verifyBulkUpdateResults();
    }

    @Test
    public void testBulkDeleteOperation() throws SQLException {
        List<Map<String, Object>> insertData = this.createBulkInsertData();
        BulkQueryDefinition insertQueryDef = this.createBulkInsertQueryDefinition();
        this.bulkOperations.bulkInsert(insertData, insertQueryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        List<Map<String, Object>> deleteData = this.createBulkDeleteData();
        BulkQueryDefinition deleteQueryDef = this.createBulkDeleteQueryDefinition();
        int[] results = this.bulkOperations.bulkDelete(deleteData, deleteQueryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        this.verifyBulkDeleteResults();
    }

    @Test
    public void testExecuteScriptWithSql() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        BulkScript script = new BulkScript("INSERT INTO bulk_test_users (name, email, age) VALUES ('Alice Johnson', 'alice@example.com', 28);\nINSERT INTO bulk_test_users (name, email, age) VALUES ('Charlie Brown', 'charlie@example.com', 32);\nUPDATE bulk_test_users SET status = 'script_updated' WHERE name = 'Alice Johnson';", null);
        QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(100), Integer.valueOf(1000));
        int[] results = this.bulkOperations.executeScript(script, settings, this.dbConnection);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)3L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        Assert.assertEquals((long)1L, (long)results[1]);
        Assert.assertEquals((long)1L, (long)results[2]);
        try (Statement stmt = this.jdbcConnection.createStatement();){
            rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users WHERE name IN ('Alice Johnson', 'Charlie Brown')");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((long)2L, (long)rs.getInt(1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        stmt = this.jdbcConnection.createStatement();
        var5_5 = null;
        try {
            rs = stmt.executeQuery("SELECT status FROM bulk_test_users WHERE name = 'Alice Johnson'");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((Object)"script_updated", (Object)rs.getString("status"));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var5_5 = throwable6;
            throw throwable6;
        }
        finally {
            if (stmt != null) {
                if (var5_5 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        var5_5.addSuppressed(throwable7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testBulkInsertWithEmptyParameters() throws SQLException {
        ArrayList emptyData = new ArrayList();
        BulkQueryDefinition queryDef = this.createBulkInsertQueryDefinition();
        int[] results = this.bulkOperations.bulkInsert(emptyData, queryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.length);
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users");){
            rs.next();
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testBulkInsertWithNullParameters() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        ArrayList dataWithNulls = new ArrayList();
        HashMap<String, String> row1 = new HashMap<String, String>();
        row1.put("name", "Test User 1");
        row1.put("email", null);
        row1.put("age", null);
        dataWithNulls.add(row1);
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("name", "Test User 2");
        row2.put("email", "test@example.com");
        row2.put("age", 25);
        dataWithNulls.add(row2);
        BulkQueryDefinition queryDef = this.createBulkInsertQueryDefinition();
        int[] results = this.bulkOperations.bulkInsert(dataWithNulls, queryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        Assert.assertEquals((long)1L, (long)results[1]);
        try (Statement stmt = this.jdbcConnection.createStatement();){
            rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users WHERE name IN ('Test User 1', 'Test User 2')");
            throwable = null;
            try {
                rs.next();
                Assert.assertEquals((long)2L, (long)rs.getInt(1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        stmt = this.jdbcConnection.createStatement();
        var7_7 = null;
        try {
            rs = stmt.executeQuery("SELECT email, age FROM bulk_test_users WHERE name = 'Test User 1'");
            throwable = null;
            try {
                rs.next();
                Assert.assertNull((Object)rs.getString("email"));
                Assert.assertNull((Object)rs.getObject("age"));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var7_7 = throwable6;
            throw throwable6;
        }
        finally {
            if (stmt != null) {
                if (var7_7 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        var7_7.addSuppressed(throwable7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testBuilderWithAllParameters() {
        BulkOperations.Builder builder = new BulkOperations.Builder().withQueryResolver((QueryResolver)new ParameterizedQueryResolver()).withBulkQueryResolver(new BulkQueryResolver()).withQueryParser((QueryTemplateParser)new SimpleQueryTemplateParser()).withBulkUpdateExecutor(BulkUpdateExecutor::new).withUpdateExecutor(factory -> new UpdateExecutor((StatementFactory)factory));
        BulkOperations result = builder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testBuilderWithDefaultValues() {
        BulkOperations.Builder builder = new BulkOperations.Builder();
        BulkOperations result = builder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDefaultBulkQueryResolver() {
        BulkQueryResolver resolver = BulkOperations.getDefaultBulkQueryResolver();
        Assert.assertNotNull((Object)resolver);
    }

    @Test
    public void testGetDefaultQueryTemplateParser() {
        QueryTemplateParser parser = BulkOperations.getDefaultQueryTemplateParser();
        Assert.assertNotNull((Object)parser);
        Assert.assertTrue((boolean)(parser instanceof SimpleQueryTemplateParser));
    }

    @Test
    public void testGetDefaultBulkExecutor() {
        Function executor = BulkOperations.getDefaultBulkExecutor();
        Assert.assertNotNull((Object)executor);
    }

    @Test
    public void testBulkInsertWithDifferentDataTypes() throws SQLException {
        ArrayList dataWithTypes = new ArrayList();
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("name", "String User");
        row1.put("email", "string@example.com");
        row1.put("age", 25);
        dataWithTypes.add(row1);
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("name", "Number User");
        row2.put("email", "number@example.com");
        row2.put("age", 30L);
        dataWithTypes.add(row2);
        HashMap<String, Object> row3 = new HashMap<String, Object>();
        row3.put("name", "Boolean User");
        row3.put("email", "boolean@example.com");
        row3.put("age", 35);
        dataWithTypes.add(row3);
        BulkQueryDefinition queryDef = this.createBulkInsertQueryDefinition();
        int[] results = this.bulkOperations.bulkInsert(dataWithTypes, queryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)3L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        Assert.assertEquals((long)1L, (long)results[1]);
        Assert.assertEquals((long)1L, (long)results[2]);
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT name, email, age FROM bulk_test_users ORDER BY name");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Boolean User", (Object)rs.getString("name"));
            Assert.assertEquals((Object)"boolean@example.com", (Object)rs.getString("email"));
            Assert.assertEquals((long)35L, (long)rs.getInt("age"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Number User", (Object)rs.getString("name"));
            Assert.assertEquals((Object)"number@example.com", (Object)rs.getString("email"));
            Assert.assertEquals((long)30L, (long)rs.getInt("age"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"String User", (Object)rs.getString("name"));
            Assert.assertEquals((Object)"string@example.com", (Object)rs.getString("email"));
            Assert.assertEquals((long)25L, (long)rs.getInt("age"));
        }
    }

    @Test
    public void testBulkOperationsWithLargeDataSet() throws SQLException {
        ArrayList largeDataSet = new ArrayList();
        for (int i = 1; i <= 10; ++i) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("name", "User " + i);
            row.put("email", "user" + i + "@example.com");
            row.put("age", 20 + i);
            largeDataSet.add(row);
        }
        BulkQueryDefinition queryDef = this.createBulkInsertQueryDefinition();
        int[] results = this.bulkOperations.bulkInsert(largeDataSet, queryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)10L, (long)results.length);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)1L, (long)results[i]);
        }
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users");){
            rs.next();
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteScriptWithFile() throws SQLException, IOException {
        File tempFile = null;
        try {
            Throwable throwable;
            ResultSet rs;
            tempFile = File.createTempFile("bulk_script", ".sql");
            String scriptContent = "INSERT INTO bulk_test_users (name, email, age) VALUES ('File User 1', 'file1@example.com', 40);\nINSERT INTO bulk_test_users (name, email, age) VALUES ('File User 2', 'file2@example.com', 41);\nUPDATE bulk_test_users SET status = 'file_updated' WHERE name = 'File User 1';";
            try (FileWriter writer = new FileWriter(tempFile);){
                writer.write(scriptContent);
            }
            BulkScript script = new BulkScript(null, tempFile.getAbsolutePath());
            QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(100), Integer.valueOf(1000));
            int[] results = this.bulkOperations.executeScript(script, settings, this.dbConnection);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)3L, (long)results.length);
            Assert.assertEquals((long)1L, (long)results[0]);
            Assert.assertEquals((long)1L, (long)results[1]);
            Assert.assertEquals((long)1L, (long)results[2]);
            try (Statement stmt = this.jdbcConnection.createStatement();){
                rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users WHERE name LIKE 'File User%'");
                throwable = null;
                try {
                    rs.next();
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            stmt = this.jdbcConnection.createStatement();
            var7_11 = null;
            try {
                rs = stmt.executeQuery("SELECT status FROM bulk_test_users WHERE name = 'File User 1'");
                throwable = null;
                try {
                    rs.next();
                    Assert.assertEquals((Object)"file_updated", (Object)rs.getString("status"));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var7_11 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var7_11 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var7_11.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    @Test
    public void testBulkOperationsBuilderWithStatementFactory() {
        QueryStatementFactory customFactory = new QueryStatementFactory();
        BulkOperations customBulkOps = new BulkOperations.Builder().withStatementFactory((ConfigurableStatementFactory)customFactory).build();
        Assert.assertNotNull((Object)customBulkOps);
    }

    @Test
    public void testResolveParamSetsWithNullParameterNames() throws SQLException {
        BulkQueryDefinition queryDef = new BulkQueryDefinition();
        queryDef.setSql("INSERT INTO bulk_test_users (name, email, age) VALUES (:name, :email, :age)");
        ArrayList testData = new ArrayList();
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("name", "Test User");
        row.put("email", "test@example.com");
        row.put("age", 25);
        testData.add(row);
        int[] results = this.bulkOperations.bulkInsert(testData, queryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM bulk_test_users WHERE name = 'Test User'");){
            rs.next();
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testResolveParamSetsWithMissingParameters() throws SQLException {
        BulkQueryDefinition queryDef = new BulkQueryDefinition();
        queryDef.setSql("INSERT INTO bulk_test_users (name, email, age) VALUES (:name, :email, :age)");
        ArrayList testData = new ArrayList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("name", "Partial User");
        row.put("email", null);
        row.put("age", null);
        testData.add(row);
        int[] results = this.bulkOperations.bulkInsert(testData, queryDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0]);
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT name, email, age FROM bulk_test_users WHERE name = 'Partial User'");){
            rs.next();
            Assert.assertEquals((Object)"Partial User", (Object)rs.getString("name"));
            Assert.assertNull((Object)rs.getString("email"));
            Assert.assertEquals((long)0L, (long)rs.getInt("age"));
        }
    }

    @Test
    public void testBaseDbOperationsValidationMethods() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QueryTemplate validTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)validTemplate.getType()).thenReturn((Object)QueryType.INSERT);
        Mockito.when((Object)validTemplate.getSqlText()).thenReturn((Object)"INSERT INTO test VALUES (?)");
        testOps.validateQueryType(validTemplate, Arrays.asList(QueryType.INSERT, QueryType.UPDATE));
        QueryTemplate invalidTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)invalidTemplate.getType()).thenReturn((Object)QueryType.SELECT);
        Mockito.when((Object)invalidTemplate.getSqlText()).thenReturn((Object)"SELECT * FROM test");
        try {
            testOps.validateQueryType(invalidTemplate, Arrays.asList(QueryType.INSERT, QueryType.UPDATE));
            Assert.fail((String)"Should have thrown BadSqlSyntaxException");
        }
        catch (BadSqlSyntaxException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Query type must be one of [INSERT, UPDATE]"));
            Assert.assertTrue((boolean)e.getMessage().contains("SELECT"));
        }
        try {
            testOps.validateQueryType(validTemplate, Collections.emptyList());
            Assert.fail((String)"Should have thrown BadSqlSyntaxException");
        }
        catch (BadSqlSyntaxException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Query type must be one of []"));
        }
    }

    @Test
    public void testBaseDbOperationsAutoGeneratedKeysStrategy() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        AutoGenerateKeysStrategy strategy = testOps.getAutoGeneratedKeysStrategy(null);
        Assert.assertTrue((boolean)(strategy instanceof NoAutoGenerateKeysStrategy));
        AutoGenerateKeysAttributes disabledAttrs = (AutoGenerateKeysAttributes)Mockito.mock(AutoGenerateKeysAttributes.class);
        Mockito.when((Object)disabledAttrs.isAutoGenerateKeys()).thenReturn((Object)false);
        strategy = testOps.getAutoGeneratedKeysStrategy(disabledAttrs);
        Assert.assertTrue((boolean)(strategy instanceof NoAutoGenerateKeysStrategy));
        AutoGenerateKeysAttributes indexAttrs = (AutoGenerateKeysAttributes)Mockito.mock(AutoGenerateKeysAttributes.class);
        Mockito.when((Object)indexAttrs.isAutoGenerateKeys()).thenReturn((Object)true);
        Mockito.when((Object)indexAttrs.getAutoGeneratedKeysColumnIndexes()).thenReturn(Arrays.asList(1, 2));
        Mockito.when((Object)indexAttrs.getAutoGeneratedKeysColumnNames()).thenReturn(Collections.emptyList());
        strategy = testOps.getAutoGeneratedKeysStrategy(indexAttrs);
        Assert.assertTrue((boolean)(strategy instanceof ColumnIndexAutoGenerateKeysStrategy));
        AutoGenerateKeysAttributes nameAttrs = (AutoGenerateKeysAttributes)Mockito.mock(AutoGenerateKeysAttributes.class);
        Mockito.when((Object)nameAttrs.isAutoGenerateKeys()).thenReturn((Object)true);
        Mockito.when((Object)nameAttrs.getAutoGeneratedKeysColumnIndexes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)nameAttrs.getAutoGeneratedKeysColumnNames()).thenReturn(Arrays.asList("id", "uuid"));
        strategy = testOps.getAutoGeneratedKeysStrategy(nameAttrs);
        Assert.assertTrue((boolean)(strategy instanceof ColumnNameAutoGenerateKeysStrategy));
        AutoGenerateKeysAttributes defaultAttrs = (AutoGenerateKeysAttributes)Mockito.mock(AutoGenerateKeysAttributes.class);
        Mockito.when((Object)defaultAttrs.isAutoGenerateKeys()).thenReturn((Object)true);
        Mockito.when((Object)defaultAttrs.getAutoGeneratedKeysColumnIndexes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)defaultAttrs.getAutoGeneratedKeysColumnNames()).thenReturn(Collections.emptyList());
        strategy = testOps.getAutoGeneratedKeysStrategy(defaultAttrs);
        Assert.assertTrue((boolean)(strategy instanceof DefaultAutoGenerateKeysStrategy));
    }

    @Test
    public void testBaseDbOperationsFetchSize() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings nullSettings = (QuerySettings)Mockito.mock(QuerySettings.class);
        Mockito.when((Object)nullSettings.getFetchSize()).thenReturn(null);
        Assert.assertEquals((long)10L, (long)testOps.getFetchSize(nullSettings));
        QuerySettings customSettings = (QuerySettings)Mockito.mock(QuerySettings.class);
        Mockito.when((Object)customSettings.getFetchSize()).thenReturn((Object)50);
        Assert.assertEquals((long)50L, (long)testOps.getFetchSize(customSettings));
    }

    @Test
    public void testBaseDbOperationsStatementFactoryWithMaxRows() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(100), Integer.valueOf(50));
        ConfigurableStatementFactory factory = testOps.getStatementFactory(settings);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testBaseDbOperationsStatementFactoryWithZeroMaxRows() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(100), Integer.valueOf(0));
        ConfigurableStatementFactory factory = testOps.getStatementFactory(settings);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testBaseDbOperationsStatementFactoryWithNegativeMaxRows() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(100), Integer.valueOf(-1));
        ConfigurableStatementFactory factory = testOps.getStatementFactory(settings);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testBaseDbOperationsStatementFactoryWithNullMaxRows() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(100), null);
        ConfigurableStatementFactory factory = testOps.getStatementFactory(settings);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testBaseDbOperationsStatementFactoryWithCustomFetchSize() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(25), Integer.valueOf(10));
        ConfigurableStatementFactory factory = testOps.getStatementFactory(settings);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testBaseDbOperationsStatementFactoryWithTimeout() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings settings = new QuerySettings(45, TimeUnit.SECONDS, Integer.valueOf(100), Integer.valueOf(1000));
        ConfigurableStatementFactory factory = testOps.getStatementFactory(settings);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testBaseDbOperationsStatementFactoryWithMillisecondTimeout() {
        BulkOperations testOps = new BulkOperations.Builder().build();
        QuerySettings settings = new QuerySettings(1500, TimeUnit.MILLISECONDS, Integer.valueOf(100), Integer.valueOf(1000));
        ConfigurableStatementFactory factory = testOps.getStatementFactory(settings);
        Assert.assertNotNull((Object)factory);
    }
}

