/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.xa;

import com.github.benmanes.caffeine.cache.Cache;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.exception.connection.ConnectionClosingException;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.xa.XADbConnection;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.StatementResultIteratorFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class XADbConnectionTestCase
extends AbstractMuleTestCase {
    private XADbConnection xaDbConnection;
    private DbConnection mockDbConnection;
    private XAConnection mockXaConnection;
    private XAResource mockXaResource;
    private Connection mockJdbcConnection;
    private StatementResultIteratorFactory mockFactory;
    private ResultSetHandler mockResultSetHandler;
    private List<DbType> mockVendorDataTypes;
    private List<DbType> mockCustomDataTypes;
    private Cache<String, QueryTemplate> mockCache;

    @Before
    public void setUp() {
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockXaConnection = (XAConnection)Mockito.mock(XAConnection.class);
        this.mockXaResource = (XAResource)Mockito.mock(XAResource.class);
        this.mockJdbcConnection = (Connection)Mockito.mock(Connection.class);
        this.mockFactory = (StatementResultIteratorFactory)Mockito.mock(StatementResultIteratorFactory.class);
        this.mockResultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        this.mockVendorDataTypes = (List)Mockito.mock(List.class);
        this.mockCustomDataTypes = (List)Mockito.mock(List.class);
        this.mockCache = (Cache)Mockito.mock(Cache.class);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockDbConnection.getStatementResultIteratorFactory(this.mockResultSetHandler)).thenReturn((Object)this.mockFactory);
        Mockito.when((Object)this.mockDbConnection.getVendorDataTypes()).thenReturn(this.mockVendorDataTypes);
        Mockito.when((Object)this.mockDbConnection.getCustomDataTypes()).thenReturn(this.mockCustomDataTypes);
        Mockito.when((Object)this.mockDbConnection.getCacheTemplates()).thenReturn(this.mockCache);
        Mockito.when((Object)this.mockDbConnection.isStreaming()).thenReturn((Object)false);
        Mockito.when((Object)this.mockDbConnection.isTransactionActive()).thenReturn((Object)false);
        Mockito.when((Object)this.mockDbConnection.supportsContentStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.mockDbConnection.hasActiveLobStreams()).thenReturn((Object)false);
        this.xaDbConnection = new XADbConnection(this.mockDbConnection, this.mockXaConnection);
    }

    @Test
    public void testConstructor() {
        MatcherAssert.assertThat((Object)this.xaDbConnection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetXAResourceSuccess() throws SQLException {
        Mockito.when((Object)this.mockXaConnection.getXAResource()).thenReturn((Object)this.mockXaResource);
        XAResource result = this.xaDbConnection.getXAResource();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)this.mockXaResource, (Object)result);
        ((XAConnection)Mockito.verify((Object)this.mockXaConnection)).getXAResource();
    }

    @Test(expected=MuleRuntimeException.class)
    public void testGetXAResourceWithSQLException() throws SQLException {
        SQLException sqlException = new SQLException("XA Resource error");
        Mockito.when((Object)this.mockXaConnection.getXAResource()).thenThrow(new Throwable[]{sqlException});
        this.xaDbConnection.getXAResource();
    }

    @Test
    public void testCloseSuccess() throws SQLException, ConnectionClosingException {
        Mockito.when((Object)this.mockJdbcConnection.isClosed()).thenReturn((Object)false);
        this.xaDbConnection.close();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).release();
        ((Connection)Mockito.verify((Object)this.mockJdbcConnection)).close();
    }

    @Test
    public void testCloseWithAlreadyClosedConnection() throws SQLException, ConnectionClosingException {
        Mockito.when((Object)this.mockJdbcConnection.isClosed()).thenReturn((Object)true);
        this.xaDbConnection.close();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).release();
    }

    @Test
    public void testCloseWithSQLException() throws SQLException, ConnectionClosingException {
        Mockito.when((Object)this.mockJdbcConnection.isClosed()).thenReturn((Object)false);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Close error")}).when((Object)this.mockJdbcConnection)).close();
        this.xaDbConnection.close();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).release();
    }

    @Test
    public void testCloseWithConnectionClosingException() throws SQLException, ConnectionClosingException {
        Mockito.when((Object)this.mockJdbcConnection.isClosed()).thenReturn((Object)false);
        ((DbConnection)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionClosingException((Throwable)new RuntimeException("Release error"))}).when((Object)this.mockDbConnection)).release();
        this.xaDbConnection.close();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).release();
    }

    @Test
    public void testBegin() throws TransactionException {
        this.xaDbConnection.begin();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).begin();
    }

    @Test
    public void testCommit() throws TransactionException {
        this.xaDbConnection.commit();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).commit();
    }

    @Test
    public void testRollback() throws TransactionException {
        this.xaDbConnection.rollback();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).rollback();
    }

    @Test
    public void testGetStatementResultIteratorFactory() {
        StatementResultIteratorFactory result = this.xaDbConnection.getStatementResultIteratorFactory(this.mockResultSetHandler);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)this.mockFactory, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getStatementResultIteratorFactory(this.mockResultSetHandler);
    }

    @Test
    public void testGetVendorDataTypes() {
        List result = this.xaDbConnection.getVendorDataTypes();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals(this.mockVendorDataTypes, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getVendorDataTypes();
    }

    @Test
    public void testGetCustomDataTypes() {
        List result = this.xaDbConnection.getCustomDataTypes();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals(this.mockCustomDataTypes, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getCustomDataTypes();
    }

    @Test
    public void testGetJdbcConnection() {
        Connection result = this.xaDbConnection.getJdbcConnection();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)this.mockJdbcConnection, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getJdbcConnection();
    }

    @Test
    public void testRelease() {
        this.xaDbConnection.release();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).release();
    }

    @Test
    public void testReleaseIfInactive() {
        this.xaDbConnection.releaseIfInactive();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).releaseIfInactive();
    }

    @Test
    public void testBeginStreaming() {
        this.xaDbConnection.beginStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).beginStreaming();
    }

    @Test
    public void testIsStreaming() {
        boolean result = this.xaDbConnection.isStreaming();
        Assert.assertFalse((boolean)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).isStreaming();
    }

    @Test
    public void testEndStreaming() {
        this.xaDbConnection.endStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).endStreaming();
    }

    @Test
    public void testIsTransactionActive() {
        boolean result = this.xaDbConnection.isTransactionActive();
    }

    @Test
    public void testSupportsContentStreaming() {
        boolean result = this.xaDbConnection.supportsContentStreaming();
        Assert.assertTrue((boolean)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).supportsContentStreaming();
    }

    @Test
    public void testIncrementActiveLobStreams() {
        this.xaDbConnection.incrementActiveLobStreams();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).incrementActiveLobStreams();
    }

    @Test
    public void testDecrementActiveLobStreams() {
        this.xaDbConnection.decrementActiveLobStreams();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).decrementActiveLobStreams();
    }

    @Test
    public void testAbortActiveLobStreams() {
        this.xaDbConnection.abortActiveLobStreams();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).abortActiveLobStreams();
    }

    @Test
    public void testHasActiveLobStreams() {
        boolean result = this.xaDbConnection.hasActiveLobStreams();
        Assert.assertFalse((boolean)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).hasActiveLobStreams();
    }

    @Test
    public void testGetCacheTemplates() {
        Cache result = this.xaDbConnection.getCacheTemplates();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals(this.mockCache, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getCacheTemplates();
    }

    @Test
    public void testCreateArray() throws SQLException {
        String typeName = "VARCHAR";
        Object[] values = new Object[]{"value1", "value2"};
        Array mockArray = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)this.mockDbConnection.createArray(typeName, values)).thenReturn((Object)mockArray);
        Array result = this.xaDbConnection.createArray(typeName, values);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)mockArray, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).createArray(typeName, values);
    }

    @Test
    public void testGetDbTypeByVendor() throws SQLException {
        String typeName = "VARCHAR";
        ResultSet mockProcedureColumns = (ResultSet)Mockito.mock(ResultSet.class);
        Optional<Object> mockDbType = Optional.of(Mockito.mock(DbType.class));
        Mockito.when((Object)this.mockDbConnection.getDbTypeByVendor(typeName, mockProcedureColumns)).thenReturn(mockDbType);
        Optional result = this.xaDbConnection.getDbTypeByVendor(typeName, mockProcedureColumns);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals(mockDbType, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getDbTypeByVendor(typeName, mockProcedureColumns);
    }
}

