/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

public class OracleResolvedTypeTestCase {
    private PreparedStatement mockPreparedStatement;
    private DbConnection mockDbConnection;
    private ResolvedDbType resolvedDbType;
    private Connection mockConnection;
    private DatabaseMetaData mockMetaData;
    private CallableStatement mockCallableStatement;

    @Before
    public void setUp() throws Exception {
        this.mockPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockConnection = (Connection)Mockito.mock(Connection.class);
        this.mockMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.mockCallableStatement = (CallableStatement)Mockito.mock(CallableStatement.class);
        Mockito.when((Object)this.mockPreparedStatement.getConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.getMetaData()).thenReturn((Object)this.mockMetaData);
        Mockito.when((Object)this.mockMetaData.getDriverName()).thenReturn((Object)"Oracle");
    }

    @Test
    public void testSetParameterValueWithDate() throws SQLException {
        String value = "2022-10-05T15:39:20.045";
        this.resolvedDbType = new ResolvedDbType(91, "DATE");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, value);
    }

    @Test
    public void testSetParameterValueWithTimestamp() throws SQLException {
        String value = "2024-08-14";
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, value);
    }

    @Test
    public void testSetParameterValueWithNullValue() throws SQLException {
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, null, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setNull(1, 93);
    }

    @Test
    public void testGetParameterValue() throws SQLException {
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        String expectedValue = "2023-10-05T15:39:20.045+02:00";
        Mockito.when((Object)this.mockCallableStatement.getObject(1)).thenReturn((Object)expectedValue);
        Object actualVale = this.resolvedDbType.getParameterValue(this.mockCallableStatement, 1);
        MatcherAssert.assertThat((Object)actualVale, (Matcher)CoreMatchers.is((Object)expectedValue));
        ((CallableStatement)Mockito.verify((Object)this.mockCallableStatement)).getObject(1);
    }

    @Test
    public void testSetParameterValueWithTimestampStringNotMatchingDateRegex() throws SQLException {
        String value = "2024-08-14T15:39:20.045";
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, (Object)value, 93);
    }

    @Test
    public void testSetParameterValueWithTimestampNonStringValue() throws SQLException {
        Timestamp value = Timestamp.valueOf("2024-08-14 15:39:20.045");
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, (Object)value, 93);
    }

    @Test
    public void testSetParameterValueWithNonOracleDriver() throws SQLException {
        Mockito.when((Object)this.mockMetaData.getDriverName()).thenReturn((Object)"MySQL JDBC Driver");
        String value = "2024-08-14";
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, (Object)value, 93);
    }

    @Test
    public void testSetParameterValueWithPostgreSQLDriver() throws SQLException {
        Mockito.when((Object)this.mockMetaData.getDriverName()).thenReturn((Object)"PostgreSQL JDBC Driver");
        String value = "2024-08-14T15:39:20.045";
        this.resolvedDbType = new ResolvedDbType(91, "DATE");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, (Object)value, 91);
    }

    @Test
    public void testSetParameterValueWithNullConnection() throws SQLException {
        PreparedStatement statementWithNullConnection = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)statementWithNullConnection.getConnection()).thenReturn(null);
        String value = "2024-08-14";
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(statementWithNullConnection, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)statementWithNullConnection)).setObject(1, (Object)value, 93);
    }

    @Test
    public void testSetParameterValueWithNullMetadata() throws SQLException {
        PreparedStatement statementWithNullMetadata = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Connection connectionWithNullMetadata = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)statementWithNullMetadata.getConnection()).thenReturn((Object)connectionWithNullMetadata);
        Mockito.when((Object)connectionWithNullMetadata.getMetaData()).thenReturn(null);
        String value = "2024-08-14";
        this.resolvedDbType = new ResolvedDbType(91, "DATE");
        this.resolvedDbType.setParameterValue(statementWithNullMetadata, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)statementWithNullMetadata)).setObject(1, (Object)value, 91);
    }

    @Test
    public void testSetParameterValueWithNullDriverName() throws SQLException {
        PreparedStatement statementWithNullDriverName = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Connection connectionWithNullDriverName = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metadataWithNullDriverName = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)statementWithNullDriverName.getConnection()).thenReturn((Object)connectionWithNullDriverName);
        Mockito.when((Object)connectionWithNullDriverName.getMetaData()).thenReturn((Object)metadataWithNullDriverName);
        Mockito.when((Object)metadataWithNullDriverName.getDriverName()).thenReturn(null);
        String value = "2024-08-14";
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(statementWithNullDriverName, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)statementWithNullDriverName)).setObject(1, (Object)value, 93);
    }
}

