/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.query;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.query.ResolvedParameter;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

@RunWith(value=MockitoJUnitRunner.class)
public class ResolvedParameterTestCase {
    @Mock
    private DbType mockDbType;

    @Test
    public void testConstructorAndGetters() {
        String name = "testParam";
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        String value = "testValue";
        int index = 1;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithNullName() {
        String name = null;
        ResolvedDbType type = new ResolvedDbType(4, "INTEGER");
        Integer value = 42;
        int index = 2;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertNull((Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithNullType() {
        String name = "nullTypeParam";
        DbType type = null;
        String value = "someValue";
        int index = 3;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertNull((Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithNullValue() {
        String name = "nullValueParam";
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        Object value = null;
        int index = 4;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertNull((Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithZeroIndex() {
        String name = "zeroIndexParam";
        ResolvedDbType type = new ResolvedDbType(16, "BOOLEAN");
        Boolean value = true;
        int index = 0;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithNegativeIndex() {
        String name = "negativeIndexParam";
        ResolvedDbType type = new ResolvedDbType(8, "DOUBLE");
        Double value = 3.14;
        int index = -1;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithLargeIndex() {
        String name = "largeIndexParam";
        ResolvedDbType type = new ResolvedDbType(-5, "BIGINT");
        Long value = 123456789L;
        int index = 999999;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithEmptyStringName() {
        String name = "";
        ResolvedDbType type = new ResolvedDbType(1, "CHAR");
        Character value = Character.valueOf('A');
        int index = 5;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithSpecialCharactersInName() {
        String name = "param_with_underscores_and_123";
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        String value = "specialValue";
        int index = 6;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testConstructorWithDifferentDataTypes() {
        ResolvedDbType varcharType = new ResolvedDbType(12, "VARCHAR");
        ResolvedDbType intType = new ResolvedDbType(4, "INTEGER");
        ResolvedDbType doubleType = new ResolvedDbType(8, "DOUBLE");
        ResolvedDbType booleanType = new ResolvedDbType(16, "BOOLEAN");
        ResolvedParameter varcharParam = new ResolvedParameter("varcharParam", (DbType)varcharType, (Object)"stringValue", 1);
        ResolvedParameter intParam = new ResolvedParameter("intParam", (DbType)intType, (Object)42, 2);
        ResolvedParameter doubleParam = new ResolvedParameter("doubleParam", (DbType)doubleType, (Object)3.14, 3);
        ResolvedParameter booleanParam = new ResolvedParameter("booleanParam", (DbType)booleanType, (Object)true, 4);
        Assert.assertEquals((Object)varcharType, (Object)varcharParam.getType());
        Assert.assertEquals((Object)intType, (Object)intParam.getType());
        Assert.assertEquals((Object)doubleType, (Object)doubleParam.getType());
        Assert.assertEquals((Object)booleanType, (Object)booleanParam.getType());
    }

    @Test
    public void testConstructorWithComplexObjects() {
        String name = "complexObjectParam";
        ResolvedDbType type = new ResolvedDbType(2000, "JAVA_OBJECT");
        String stringValue = "stringObject";
        Integer intValue = 123;
        Double doubleValue = 456.789;
        Boolean booleanValue = false;
        Object nullValue = null;
        ResolvedParameter stringParam = new ResolvedParameter(name, (DbType)type, (Object)stringValue, 1);
        ResolvedParameter intParam = new ResolvedParameter(name, (DbType)type, (Object)intValue, 2);
        ResolvedParameter doubleParam = new ResolvedParameter(name, (DbType)type, (Object)doubleValue, 3);
        ResolvedParameter booleanParam = new ResolvedParameter(name, (DbType)type, (Object)booleanValue, 4);
        ResolvedParameter nullParam = new ResolvedParameter(name, (DbType)type, nullValue, 5);
        Assert.assertEquals((Object)stringValue, (Object)stringParam.getValue());
        Assert.assertEquals((Object)intValue, (Object)intParam.getValue());
        Assert.assertEquals((Object)doubleValue, (Object)doubleParam.getValue());
        Assert.assertEquals((Object)booleanValue, (Object)booleanParam.getValue());
        Assert.assertEquals(nullValue, (Object)nullParam.getValue());
    }

    @Test
    public void testMultipleInstances() {
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        ResolvedParameter param1 = new ResolvedParameter("param1", (DbType)type, (Object)"value1", 1);
        ResolvedParameter param2 = new ResolvedParameter("param2", (DbType)type, (Object)"value2", 2);
        ResolvedParameter param3 = new ResolvedParameter("param3", (DbType)type, (Object)"value3", 3);
        Assert.assertEquals((Object)"param1", (Object)param1.getName());
        Assert.assertEquals((Object)"value1", (Object)param1.getValue());
        Assert.assertEquals((long)1L, (long)param1.getIndex());
        Assert.assertEquals((Object)"param2", (Object)param2.getName());
        Assert.assertEquals((Object)"value2", (Object)param2.getValue());
        Assert.assertEquals((long)2L, (long)param2.getIndex());
        Assert.assertEquals((Object)"param3", (Object)param3.getName());
        Assert.assertEquals((Object)"value3", (Object)param3.getValue());
        Assert.assertEquals((long)3L, (long)param3.getIndex());
    }

    @Test
    public void testImmutability() {
        String name = "immutableParam";
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        String value = "immutableValue";
        int index = 1;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)type, (Object)resolvedParameter.getType());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
        ResolvedParameter anotherParam = new ResolvedParameter("differentName", (DbType)type, (Object)"differentValue", 2);
        Assert.assertEquals((Object)name, (Object)resolvedParameter.getName());
        Assert.assertEquals((Object)value, (Object)resolvedParameter.getValue());
        Assert.assertEquals((long)index, (long)resolvedParameter.getIndex());
    }

    @Test
    public void testEdgeCases() {
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            sb.append("a");
        }
        String longName = sb.toString();
        ResolvedParameter longNameParam = new ResolvedParameter(longName, (DbType)type, (Object)"value", 1);
        Assert.assertEquals((Object)longName, (Object)longNameParam.getName());
        int largeIndex = Integer.MAX_VALUE;
        ResolvedParameter largeIndexParam = new ResolvedParameter("name", (DbType)type, (Object)"value", largeIndex);
        Assert.assertEquals((long)largeIndex, (long)largeIndexParam.getIndex());
        int largeNegativeIndex = Integer.MIN_VALUE;
        ResolvedParameter largeNegativeIndexParam = new ResolvedParameter("name", (DbType)type, (Object)"value", largeNegativeIndex);
        Assert.assertEquals((long)largeNegativeIndex, (long)largeNegativeIndexParam.getIndex());
    }

    @Test
    public void testToString() {
        String name = "toStringParam";
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        String value = "toStringValue";
        int index = 1;
        ResolvedParameter resolvedParameter = new ResolvedParameter(name, (DbType)type, (Object)value, index);
        String toString = resolvedParameter.toString();
        Assert.assertNotNull((Object)toString);
        Assert.assertTrue((boolean)toString.contains("ResolvedParameter"));
    }

    @Test
    public void testEqualsAndHashCode() {
        ResolvedDbType type = new ResolvedDbType(12, "VARCHAR");
        ResolvedParameter param1 = new ResolvedParameter("name", (DbType)type, (Object)"value", 1);
        ResolvedParameter param2 = new ResolvedParameter("name", (DbType)type, (Object)"value", 1);
        ResolvedParameter param3 = new ResolvedParameter("differentName", (DbType)type, (Object)"value", 1);
        Assert.assertFalse((boolean)param1.equals(param2));
        Assert.assertFalse((boolean)param1.equals(param3));
        Assert.assertFalse((boolean)param1.equals(null));
        Assert.assertTrue((boolean)param1.equals(param1));
        Assert.assertNotEquals((long)param1.hashCode(), (long)param2.hashCode());
        Assert.assertNotEquals((long)param1.hashCode(), (long)param3.hashCode());
    }
}

