/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.metadata;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.metadata.DbInputMetadataResolver;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;

public class DbInputMetadataResolverTest {
    @Test
    public void getInputMetadataWhenDriverDoesNotSupportToMapTypeToClassName() throws MetadataResolvingException, ConnectionException, SQLException {
        boolean CHAR_TYPE = true;
        final PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        DbInputMetadataResolver dbInputMetadataResolver = new DbInputMetadataResolver(){

            protected PreparedStatement getStatement(MetadataContext context, QueryTemplate query) throws ConnectionException, MetadataResolvingException {
                return preparedStatement;
            }
        };
        ParameterMetaData parameterMetaData = (ParameterMetaData)Mockito.mock(ParameterMetaData.class);
        Mockito.when((Object)preparedStatement.getParameterMetaData()).thenReturn((Object)parameterMetaData);
        Mockito.when((Object)parameterMetaData.getParameterClassName(ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new RuntimeException("Not supported")});
        Mockito.when((Object)parameterMetaData.getParameterType(ArgumentMatchers.anyInt())).thenReturn((Object)1);
        MetadataContext metadataContext = (MetadataContext)Mockito.mock(MetadataContext.class);
        Mockito.when((Object)metadataContext.getTypeBuilder()).thenReturn((Object)new BaseTypeBuilder(MetadataFormat.JAVA));
        Mockito.when((Object)metadataContext.getTypeLoader()).thenReturn((Object)new JavaTypeLoader(this.getClass().getClassLoader()));
        MetadataType inputMetadata = dbInputMetadataResolver.getInputMetadata(metadataContext, "select * from A where P1 = :P1 AND P2 = :P2");
        Assert.assertEquals((Object)MetadataFormat.JAVA, (Object)inputMetadata.getMetadataFormat());
        ObjectType inputMetadataObject = (ObjectType)inputMetadata;
        MatcherAssert.assertThat((Object)inputMetadataObject.getFields().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }
}

