/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.datasource;

import java.lang.reflect.Field;
import java.util.Optional;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnectionProvider;
import org.mule.db.commons.internal.domain.connection.datasource.DataSourceReferenceConnectionProvider;
import org.mule.db.commons.internal.domain.connection.datasource.DefaultDatasourceConnectionSettings;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DataSourceReferenceConnectionProviderTestCase
extends AbstractMuleTestCase {
    private DataSourceReferenceConnectionProvider provider;
    private DefaultDatasourceConnectionSettings mockSettings;
    private DataSource mockDataSource;

    @Before
    public void setUp() {
        this.provider = new DataSourceReferenceConnectionProvider();
        this.mockSettings = (DefaultDatasourceConnectionSettings)Mockito.mock(DefaultDatasourceConnectionSettings.class);
        this.mockDataSource = (DataSource)Mockito.mock(DataSource.class);
    }

    @Test
    public void testGetDataSourceReturnsEmptyWhenSettingsIsNull() {
    }

    @Test
    public void testGetDataSourceReturnsDataSourceWhenSettingsHasDataSource() throws Exception {
        Field field = DataSourceReferenceConnectionProvider.class.getDeclaredField("connectionSettings");
        field.setAccessible(true);
        field.set(this.provider, this.mockSettings);
        Mockito.when((Object)this.mockSettings.getDataSourceRef()).thenReturn((Object)this.mockDataSource);
        Optional result = this.provider.getDataSource();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(result.get(), (Matcher)CoreMatchers.is((Object)this.mockDataSource));
    }

    @Test
    public void testGetDataSourceReturnsEmptyWhenSettingsReturnsNull() throws Exception {
        Field field = DataSourceReferenceConnectionProvider.class.getDeclaredField("connectionSettings");
        field.setAccessible(true);
        field.set(this.provider, this.mockSettings);
        Mockito.when((Object)this.mockSettings.getDataSourceRef()).thenReturn(null);
        Optional result = this.provider.getDataSource();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetDataSourceConfigReturnsEmpty() {
        Optional result = this.provider.getDataSourceConfig();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testClassExtendsDbConnectionProvider() {
        MatcherAssert.assertThat((Object)(this.provider instanceof DbConnectionProvider), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.provider.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.connection.datasource"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.provider.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"DataSourceReferenceConnectionProvider"));
    }
}

