/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.exception.connection.ConnectionCreationException;
import org.mule.db.commons.internal.domain.connection.JdbcConnectionFactory;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.MappedStructResolvedDbType;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class JdbcConnectionFactoryTestCase
extends AbstractMuleTestCase {
    private JdbcConnectionFactory jdbcConnectionFactory;
    private DataSource mockDataSource;
    private Connection mockConnection;
    private Function<String, String> mockMaskCredentialsFunction;

    @Before
    public void setUp() {
        this.mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        this.mockConnection = (Connection)Mockito.mock(Connection.class);
        this.mockMaskCredentialsFunction = (Function)Mockito.mock(Function.class);
        this.jdbcConnectionFactory = new JdbcConnectionFactory.Builder().withMaskCredentialsFunction(this.mockMaskCredentialsFunction).build();
    }

    @Test
    public void testConstructorWithValidBuilder() {
        MatcherAssert.assertThat((Object)this.jdbcConnectionFactory, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreateConnectionSuccess() throws SQLException, ConnectionCreationException {
        Mockito.when((Object)this.mockDataSource.getConnection()).thenReturn((Object)this.mockConnection);
        List customDataTypes = Collections.emptyList();
        Connection result = this.jdbcConnectionFactory.createConnection(this.mockDataSource, customDataTypes);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockConnection));
    }

    @Test
    public void testCreateConnectionWithCustomDataTypes() throws SQLException, ConnectionCreationException {
        Mockito.when((Object)this.mockDataSource.getConnection()).thenReturn((Object)this.mockConnection);
        MappedStructResolvedDbType mockStructDbType = (MappedStructResolvedDbType)Mockito.mock(MappedStructResolvedDbType.class);
        Mockito.when((Object)mockStructDbType.getMappedClass()).thenReturn(String.class);
        Mockito.when((Object)mockStructDbType.getName()).thenReturn((Object)"TEST_TYPE");
        List<DbType> customDataTypes = Arrays.asList(mockStructDbType);
        Connection result = this.jdbcConnectionFactory.createConnection(this.mockDataSource, customDataTypes);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockConnection));
    }

    @Test
    public void testCreateConnectionWithNullMappedClass() throws SQLException, ConnectionCreationException {
        Mockito.when((Object)this.mockDataSource.getConnection()).thenReturn((Object)this.mockConnection);
        MappedStructResolvedDbType mockStructDbType = (MappedStructResolvedDbType)Mockito.mock(MappedStructResolvedDbType.class);
        Mockito.when((Object)mockStructDbType.getMappedClass()).thenReturn(null);
        Mockito.when((Object)mockStructDbType.getName()).thenReturn((Object)"TEST_TYPE");
        List<DbType> customDataTypes = Arrays.asList(mockStructDbType);
        Connection result = this.jdbcConnectionFactory.createConnection(this.mockDataSource, customDataTypes);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockConnection));
    }

    @Test
    public void testCreateConnectionWithNonStructDbType() throws SQLException, ConnectionCreationException {
        Mockito.when((Object)this.mockDataSource.getConnection()).thenReturn((Object)this.mockConnection);
        DbType mockDbType = (DbType)Mockito.mock(DbType.class);
        List<DbType> customDataTypes = Arrays.asList(mockDbType);
        Connection result = this.jdbcConnectionFactory.createConnection(this.mockDataSource, customDataTypes);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockConnection));
    }

    @Test(expected=ConnectionCreationException.class)
    public void testCreateConnectionWithNullConnection() throws SQLException, ConnectionCreationException {
        Mockito.when((Object)this.mockDataSource.getConnection()).thenReturn(null);
        List customDataTypes = Collections.emptyList();
        this.jdbcConnectionFactory.createConnection(this.mockDataSource, customDataTypes);
    }

    @Test(expected=SQLException.class)
    public void testCreateConnectionWithSQLException() throws SQLException, ConnectionCreationException {
        SQLException sqlException = new SQLException("Test SQL Exception", "SQL_STATE", 123);
        Mockito.when((Object)this.mockDataSource.getConnection()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)this.mockMaskCredentialsFunction.apply("Test SQL Exception")).thenReturn((Object)"Masked SQL Exception");
        List customDataTypes = Collections.emptyList();
        this.jdbcConnectionFactory.createConnection(this.mockDataSource, customDataTypes);
    }

    @Test
    public void testBuilderWithMaskCredentialsFunction() {
        Function<String, String> customMaskFunction = s -> "MASKED_" + s;
        JdbcConnectionFactory factory = new JdbcConnectionFactory.Builder().withMaskCredentialsFunction(customMaskFunction).build();
        MatcherAssert.assertThat((Object)factory, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testBuilderWithoutMaskCredentialsFunction() {
        JdbcConnectionFactory factory = new JdbcConnectionFactory.Builder().build();
        MatcherAssert.assertThat((Object)factory, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.jdbcConnectionFactory.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.connection"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.jdbcConnectionFactory.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"JdbcConnectionFactory"));
    }

    @Test
    public void testBuilderClassExists() {
        MatcherAssert.assertThat(JdbcConnectionFactory.Builder.class, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testBuilderWithMaskCredentialsFunctionMethod() {
        Function<String, String> customMaskFunction = s -> "MASKED_" + s;
        JdbcConnectionFactory.Builder builder = new JdbcConnectionFactory.Builder();
        JdbcConnectionFactory.Builder result = builder.withMaskCredentialsFunction(customMaskFunction);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)builder));
    }
}

