/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import com.github.benmanes.caffeine.cache.Cache;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.StatementResultIteratorFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DbConnectionTestCase
extends AbstractMuleTestCase {
    private TestDbConnection testConnection;
    private Connection mockJdbcConnection;
    private DatabaseMetaData mockDatabaseMetaData;
    private ResultSet mockResultSet;

    @Before
    public void setUp() {
        this.mockJdbcConnection = (Connection)Mockito.mock(Connection.class);
        this.mockDatabaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        this.testConnection = new TestDbConnection(this.mockJdbcConnection);
    }

    @Test
    public void testInterfaceExists() {
        MatcherAssert.assertThat(DbConnection.class, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)DbConnection.class.isInterface(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInterfaceExtendsTransactionalConnection() {
        Class<?>[] interfaces = DbConnection.class.getInterfaces();
        boolean extendsTransactionalConnection = false;
        for (Class<?> interfaceClass : interfaces) {
            if (!interfaceClass.getName().equals("org.mule.runtime.extension.api.connectivity.TransactionalConnection")) continue;
            extendsTransactionalConnection = true;
            break;
        }
        MatcherAssert.assertThat((String)"DbConnection should extend TransactionalConnection", (boolean)extendsTransactionalConnection);
    }

    @Test
    public void testInterfacePackage() {
        String packageName = DbConnection.class.getPackage().getName();
        MatcherAssert.assertThat((Object)packageName, (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.connection"));
    }

    @Test
    public void testInterfaceName() {
        String className = DbConnection.class.getSimpleName();
        MatcherAssert.assertThat((Object)className, (Matcher)CoreMatchers.is((Object)"DbConnection"));
    }

    @Test
    public void testInterfaceMethodsExist() {
        try {
            Method[] methods = DbConnection.class.getMethods();
            MatcherAssert.assertThat((Object)methods.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            boolean hasGetJdbcConnection = false;
            boolean hasGetCustomDataTypes = false;
            boolean hasGetVendorDataTypes = false;
            boolean hasIsStreaming = false;
            boolean hasIsTransactionActive = false;
            for (Method method : methods) {
                if (method.getName().equals("getJdbcConnection")) {
                    hasGetJdbcConnection = true;
                }
                if (method.getName().equals("getCustomDataTypes")) {
                    hasGetCustomDataTypes = true;
                }
                if (method.getName().equals("getVendorDataTypes")) {
                    hasGetVendorDataTypes = true;
                }
                if (method.getName().equals("isStreaming")) {
                    hasIsStreaming = true;
                }
                if (!method.getName().equals("isTransactionActive")) continue;
                hasIsTransactionActive = true;
            }
            MatcherAssert.assertThat((String)"Interface should have getJdbcConnection method", (boolean)hasGetJdbcConnection);
            MatcherAssert.assertThat((String)"Interface should have getCustomDataTypes method", (boolean)hasGetCustomDataTypes);
            MatcherAssert.assertThat((String)"Interface should have getVendorDataTypes method", (boolean)hasGetVendorDataTypes);
            MatcherAssert.assertThat((String)"Interface should have isStreaming method", (boolean)hasIsStreaming);
            MatcherAssert.assertThat((String)"Interface should have isTransactionActive method", (boolean)hasIsTransactionActive);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((String)"Should not throw exception when accessing interface methods", (boolean)false);
        }
    }

    @Test
    public void testCreateArrayOfWithObjectArray() throws SQLException {
        Array mockArray = (Array)Mockito.mock(Array.class);
        Object[] values = new Object[]{"value1", "value2"};
        Mockito.when((Object)this.mockJdbcConnection.createArrayOf("VARCHAR", values)).thenReturn((Object)mockArray);
        Array result = this.testConnection.createArrayOf("VARCHAR", values);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)mockArray));
    }

    @Test
    public void testCreateArrayOfWithSingleObject() throws SQLException {
        Array mockArray = (Array)Mockito.mock(Array.class);
        String value = "singleValue";
        Mockito.when((Object)this.mockJdbcConnection.createArrayOf("VARCHAR", new Object[]{"singleValue"})).thenReturn((Object)mockArray);
        Array result = this.testConnection.createArrayOf("VARCHAR", value);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)mockArray));
    }

    @Test
    public void testCreateArrayOfWithCollection() throws SQLException {
        Array mockArray = (Array)Mockito.mock(Array.class);
        List<String> values = Arrays.asList("value1", "value2");
        Mockito.when((Object)this.mockJdbcConnection.createArrayOf("VARCHAR", new Object[]{"value1", "value2"})).thenReturn((Object)mockArray);
        Array result = this.testConnection.createArrayOf("VARCHAR", values);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)mockArray));
    }

    @Test
    public void testCreateArrayWithObjectArray() throws SQLException {
        Array mockArray = (Array)Mockito.mock(Array.class);
        Object[] values = new Object[]{"value1", "value2"};
        Mockito.when((Object)this.mockJdbcConnection.createArrayOf("VARCHAR", values)).thenReturn((Object)mockArray);
        Array result = this.testConnection.createArray("VARCHAR", values);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)mockArray));
    }

    @Test
    public void testCreateArrayWithSingleObject() throws SQLException {
        Array mockArray = (Array)Mockito.mock(Array.class);
        String value = "singleValue";
        Mockito.when((Object)this.mockJdbcConnection.createArrayOf("VARCHAR", new Object[]{"singleValue"})).thenReturn((Object)mockArray);
        Array result = this.testConnection.createArray("VARCHAR", value);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)mockArray));
    }

    @Test
    public void testCreateArrayWithCollection() throws SQLException {
        Array mockArray = (Array)Mockito.mock(Array.class);
        List<String> values = Arrays.asList("value1", "value2");
        Mockito.when((Object)this.mockJdbcConnection.createArrayOf("VARCHAR", new Object[]{"value1", "value2"})).thenReturn((Object)mockArray);
        Array result = this.testConnection.createArray("VARCHAR", values);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)mockArray));
    }

    @Test
    public void testCreateStruct() throws SQLException {
        Struct mockStruct = (Struct)Mockito.mock(Struct.class);
        Object[] values = new Object[]{"value1", "value2"};
        Mockito.when((Object)this.mockJdbcConnection.createStruct("TEST_STRUCT", values)).thenReturn((Object)mockStruct);
        Struct result = this.testConnection.createStruct("TEST_STRUCT", values);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)mockStruct));
    }

    @Test
    public void testGetProcedureColumnsWithOwner() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.getMetaData()).thenReturn((Object)this.mockDatabaseMetaData);
        Mockito.when((Object)this.mockDatabaseMetaData.getProcedureColumns("catalog", "owner", "procedure", "%")).thenReturn((Object)this.mockResultSet);
        ResultSet result = this.testConnection.getProcedureColumns("procedure", "owner", "parentOwner", "catalog");
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockResultSet));
    }

    @Test
    public void testGetProcedureColumnsWithoutOwner() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.getMetaData()).thenReturn((Object)this.mockDatabaseMetaData);
        Mockito.when((Object)this.mockDatabaseMetaData.getProcedureColumns("catalog", null, "procedure", "%")).thenReturn((Object)this.mockResultSet);
        ResultSet result = this.testConnection.getProcedureColumns("procedure", null, "parentOwner", "catalog");
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockResultSet));
    }

    @Test
    public void testGetProcedureColumnType() throws SQLException {
        Optional result = this.testConnection.getProcedureColumnType("procedure", "column", "owner");
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetTables() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.getMetaData()).thenReturn((Object)this.mockDatabaseMetaData);
        Mockito.when((Object)this.mockDatabaseMetaData.getTables(null, null, "%", null)).thenReturn((Object)this.mockResultSet);
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.mockResultSet.getString(3)).thenReturn((Object)"table1", (Object[])new String[]{"table2"});
        Set result = this.testConnection.getTables();
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)result.contains("table1"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)result.contains("table2"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetDbTypeByVendor() throws SQLException {
        Optional result = this.testConnection.getDbTypeByVendor("VARCHAR", this.mockResultSet);
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static class TestDbConnection
    implements DbConnection {
        private final Connection jdbcConnection;

        public TestDbConnection(Connection jdbcConnection) {
            this.jdbcConnection = jdbcConnection;
        }

        public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
            return null;
        }

        public List<DbType> getCustomDataTypes() {
            return null;
        }

        public List<DbType> getVendorDataTypes() {
            return null;
        }

        public Connection getJdbcConnection() {
            return this.jdbcConnection;
        }

        public void release() {
        }

        public void releaseIfInactive() {
        }

        public void beginStreaming() {
        }

        public boolean isStreaming() {
            return false;
        }

        public void endStreaming() {
        }

        public boolean isTransactionActive() {
            return false;
        }

        public boolean supportsContentStreaming() {
            return false;
        }

        public void incrementActiveLobStreams() {
        }

        public void decrementActiveLobStreams() {
        }

        public void abortActiveLobStreams() {
        }

        public boolean hasActiveLobStreams() {
            return false;
        }

        public Cache<String, QueryTemplate> getCacheTemplates() {
            return null;
        }

        public void begin() {
        }

        public void commit() {
        }

        public void rollback() {
        }
    }
}

