/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.autogeneratedkey.DefaultAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultAutoGenerateKeysStrategyTestCase {
    @Mock
    private DbConnection mockDbConnection;
    @Mock
    private QueryTemplate mockQueryTemplate;
    @Mock
    private Connection mockJdbcConnection;
    @Mock
    private PreparedStatement mockPreparedStatement;
    @Mock
    private Statement mockStatement;
    private DefaultAutoGenerateKeysStrategy strategy;

    @Before
    public void setUp() {
        this.strategy = new DefaultAutoGenerateKeysStrategy();
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.strategy);
    }

    @Test
    public void testReturnsAutoGenerateKeys() {
        boolean result = this.strategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPrepareStatement() throws SQLException {
        String sqlText = "INSERT INTO users (name) VALUES (?)";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(sqlText, 1)).thenReturn((Object)this.mockPreparedStatement);
        PreparedStatement result = this.strategy.prepareStatement(this.mockDbConnection, this.mockQueryTemplate);
        Assert.assertSame((Object)this.mockPreparedStatement, (Object)result);
        ((Connection)Mockito.verify((Object)this.mockJdbcConnection)).prepareStatement(sqlText, 1);
    }

    @Test
    public void testPrepareStatementWithNullConnection() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.prepareStatement(null, this.mockQueryTemplate));
    }

    @Test
    public void testPrepareStatementWithNullQueryTemplate() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.prepareStatement(this.mockDbConnection, null));
    }

    @Test
    public void testPrepareStatementWithSQLException() throws SQLException {
        String sqlText = "INSERT INTO users (name) VALUES (?)";
        SQLException sqlException = new SQLException("Database error");
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(sqlText, 1)).thenThrow(new Throwable[]{sqlException});
        SQLException exception = (SQLException)Assert.assertThrows(SQLException.class, () -> this.strategy.prepareStatement(this.mockDbConnection, this.mockQueryTemplate));
        Assert.assertEquals((Object)sqlException, (Object)exception);
    }

    @Test
    public void testExecuteWithPreparedStatement() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.execute()).thenReturn((Object)true);
        boolean result = this.strategy.execute((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertTrue((boolean)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).execute();
    }

    @Test
    public void testExecuteWithStatement() throws SQLException {
        String sqlText = "INSERT INTO users (name) VALUES (?)";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockStatement.execute(sqlText, 1)).thenReturn((Object)true);
        boolean result = this.strategy.execute(this.mockStatement, this.mockQueryTemplate);
        Assert.assertTrue((boolean)result);
        ((Statement)Mockito.verify((Object)this.mockStatement)).execute(sqlText, 1);
    }

    @Test
    public void testExecuteWithNullStatement() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.execute(null, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteWithNullQueryTemplate() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.execute(this.mockStatement, null));
    }

    @Test
    public void testExecuteWithSQLException() throws SQLException {
        SQLException sqlException = new SQLException("Database error");
        Mockito.when((Object)this.mockPreparedStatement.execute()).thenThrow(new Throwable[]{sqlException});
        SQLException exception = (SQLException)Assert.assertThrows(SQLException.class, () -> this.strategy.execute((Statement)this.mockPreparedStatement, this.mockQueryTemplate));
        Assert.assertEquals((Object)sqlException, (Object)exception);
    }

    @Test
    public void testExecuteUpdateWithPreparedStatement() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.executeUpdate()).thenReturn((Object)1);
        int result = this.strategy.executeUpdate((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertEquals((long)1L, (long)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).executeUpdate();
    }

    @Test
    public void testExecuteUpdateWithStatement() throws SQLException {
        String sqlText = "INSERT INTO users (name) VALUES (?)";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockStatement.executeUpdate(sqlText, 1)).thenReturn((Object)1);
        int result = this.strategy.executeUpdate(this.mockStatement, this.mockQueryTemplate);
        Assert.assertEquals((long)1L, (long)result);
        ((Statement)Mockito.verify((Object)this.mockStatement)).executeUpdate(sqlText, 1);
    }

    @Test
    public void testExecuteUpdateWithNullStatement() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.executeUpdate(null, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteUpdateWithNullQueryTemplate() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.executeUpdate(this.mockStatement, null));
    }

    @Test
    public void testExecuteUpdateWithSQLException() throws SQLException {
        SQLException sqlException = new SQLException("Database error");
        Mockito.when((Object)this.mockPreparedStatement.executeUpdate()).thenThrow(new Throwable[]{sqlException});
        SQLException exception = (SQLException)Assert.assertThrows(SQLException.class, () -> this.strategy.executeUpdate((Statement)this.mockPreparedStatement, this.mockQueryTemplate));
        Assert.assertEquals((Object)sqlException, (Object)exception);
    }

    @Test
    public void testMultipleCallsReturnSameResult() {
        boolean result1 = this.strategy.returnsAutoGenerateKeys();
        boolean result2 = this.strategy.returnsAutoGenerateKeys();
        boolean result3 = this.strategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result1);
        Assert.assertTrue((boolean)result2);
        Assert.assertTrue((boolean)result3);
    }

    @Test
    public void testExecuteWithDifferentReturnValues() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.execute()).thenReturn((Object)false);
        boolean result = this.strategy.execute((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertFalse((boolean)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).execute();
    }

    @Test
    public void testExecuteUpdateWithDifferentReturnValues() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.executeUpdate()).thenReturn((Object)5);
        int result = this.strategy.executeUpdate((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertEquals((long)5L, (long)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).executeUpdate();
    }
}

