/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnNameAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class ColumnNameAutoGenerateKeysStrategyTestCase {
    @Mock
    private DbConnection mockDbConnection;
    @Mock
    private QueryTemplate mockQueryTemplate;
    @Mock
    private Connection mockJdbcConnection;
    @Mock
    private PreparedStatement mockPreparedStatement;
    @Mock
    private Statement mockStatement;
    private ColumnNameAutoGenerateKeysStrategy strategy;
    private String[] columnNames;

    @Before
    public void setUp() {
        this.columnNames = new String[]{"id", "uuid"};
        this.strategy = new ColumnNameAutoGenerateKeysStrategy(this.columnNames);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.strategy);
    }

    @Test
    public void testConstructorWithNullColumnNames() {
        ColumnNameAutoGenerateKeysStrategy strategyWithNull = new ColumnNameAutoGenerateKeysStrategy(null);
        Assert.assertNotNull((Object)strategyWithNull);
    }

    @Test
    public void testConstructorWithEmptyColumnNames() {
        ColumnNameAutoGenerateKeysStrategy strategyWithEmpty = new ColumnNameAutoGenerateKeysStrategy(new String[0]);
        Assert.assertNotNull((Object)strategyWithEmpty);
    }

    @Test
    public void testReturnsAutoGenerateKeys() {
        boolean result = this.strategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPrepareStatement() throws SQLException {
        String sqlText = "INSERT INTO users (name, email) VALUES (?, ?)";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(sqlText, this.columnNames)).thenReturn((Object)this.mockPreparedStatement);
        PreparedStatement result = this.strategy.prepareStatement(this.mockDbConnection, this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockPreparedStatement, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getJdbcConnection();
        ((Connection)Mockito.verify((Object)this.mockJdbcConnection)).prepareStatement(sqlText, this.columnNames);
    }

    @Test
    public void testPrepareStatementWithNullConnection() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.prepareStatement(null, this.mockQueryTemplate));
    }

    @Test
    public void testPrepareStatementWithNullQueryTemplate() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.prepareStatement(this.mockDbConnection, null));
    }

    @Test
    public void testPrepareStatementWithSQLException() throws SQLException {
        String sqlText = "INSERT INTO users (name, email) VALUES (?, ?)";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(sqlText, this.columnNames)).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertThrows(SQLException.class, () -> this.strategy.prepareStatement(this.mockDbConnection, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteWithPreparedStatement() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.execute()).thenReturn((Object)true);
        boolean result = this.strategy.execute((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertTrue((boolean)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).execute();
    }

    @Test
    public void testExecuteWithStatement() throws SQLException {
        String sqlText = "INSERT INTO users (name, email) VALUES ('John', 'john@example.com')";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockStatement.execute(sqlText, this.columnNames)).thenReturn((Object)true);
        boolean result = this.strategy.execute(this.mockStatement, this.mockQueryTemplate);
        Assert.assertTrue((boolean)result);
        ((Statement)Mockito.verify((Object)this.mockStatement)).execute(sqlText, this.columnNames);
    }

    @Test
    public void testExecuteWithNullStatement() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.execute(null, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteWithNullQueryTemplate() throws SQLException {
        this.strategy.execute((Statement)this.mockPreparedStatement, null);
    }

    @Test
    public void testExecuteWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.execute()).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertThrows(SQLException.class, () -> this.strategy.execute((Statement)this.mockPreparedStatement, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteUpdateWithPreparedStatement() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.executeUpdate()).thenReturn((Object)1);
        int result = this.strategy.executeUpdate((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertEquals((long)1L, (long)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).executeUpdate();
    }

    @Test
    public void testExecuteUpdateWithStatement() throws SQLException {
        String sqlText = "UPDATE users SET name = 'John' WHERE id = 1";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockStatement.executeUpdate(sqlText, this.columnNames)).thenReturn((Object)1);
        int result = this.strategy.executeUpdate(this.mockStatement, this.mockQueryTemplate);
        Assert.assertEquals((long)1L, (long)result);
        ((Statement)Mockito.verify((Object)this.mockStatement)).executeUpdate(sqlText, this.columnNames);
    }

    @Test
    public void testExecuteUpdateWithNullStatement() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.executeUpdate(null, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteUpdateWithNullQueryTemplate() throws SQLException {
        this.strategy.executeUpdate((Statement)this.mockPreparedStatement, null);
    }

    @Test
    public void testExecuteUpdateWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.executeUpdate()).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertThrows(SQLException.class, () -> this.strategy.executeUpdate((Statement)this.mockPreparedStatement, this.mockQueryTemplate));
    }

    @Test
    public void testStrategyImplementsAutoGenerateKeysStrategy() {
        Assert.assertTrue((boolean)(this.strategy instanceof AutoGenerateKeysStrategy));
    }

    @Test
    public void testStrategyPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.autogeneratedkey", (Object)ColumnNameAutoGenerateKeysStrategy.class.getPackage().getName());
    }

    @Test
    public void testStrategyClassName() {
        Assert.assertEquals((Object)"ColumnNameAutoGenerateKeysStrategy", (Object)ColumnNameAutoGenerateKeysStrategy.class.getSimpleName());
    }

    @Test
    public void testStrategyFullClassName() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.autogeneratedkey.ColumnNameAutoGenerateKeysStrategy", (Object)ColumnNameAutoGenerateKeysStrategy.class.getName());
    }

    @Test
    public void testMultipleInstances() {
        String[] columnNames1 = new String[]{"id"};
        String[] columnNames2 = new String[]{"uuid", "timestamp"};
        ColumnNameAutoGenerateKeysStrategy strategy1 = new ColumnNameAutoGenerateKeysStrategy(columnNames1);
        ColumnNameAutoGenerateKeysStrategy strategy2 = new ColumnNameAutoGenerateKeysStrategy(columnNames2);
        Assert.assertNotNull((Object)strategy1);
        Assert.assertNotNull((Object)strategy2);
        Assert.assertNotSame((Object)strategy1, (Object)strategy2);
        Assert.assertEquals((Object)strategy1.returnsAutoGenerateKeys(), (Object)strategy2.returnsAutoGenerateKeys());
    }

    @Test
    public void testWithSingleColumnName() {
        String[] singleColumn = new String[]{"id"};
        ColumnNameAutoGenerateKeysStrategy singleStrategy = new ColumnNameAutoGenerateKeysStrategy(singleColumn);
        boolean result = singleStrategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testWithMultipleColumnNames() {
        String[] multipleColumns = new String[]{"id", "uuid", "created_at"};
        ColumnNameAutoGenerateKeysStrategy multipleStrategy = new ColumnNameAutoGenerateKeysStrategy(multipleColumns);
        boolean result = multipleStrategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }
}

