/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnIndexAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnNameAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.DefaultAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.NoAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class AutoGenerateKeysStrategyTestCase {
    @Mock
    private DbConnection dbConnection;
    @Mock
    private Connection jdbcConnection;
    @Mock
    private QueryTemplate queryTemplate;
    @Mock
    private PreparedStatement preparedStatement;
    @Mock
    private Statement statement;

    @Before
    public void setUp() throws SQLException {
        Mockito.when((Object)this.dbConnection.getJdbcConnection()).thenReturn((Object)this.jdbcConnection);
        Mockito.when((Object)this.queryTemplate.getSqlText()).thenReturn((Object)"INSERT INTO test_table (name) VALUES (?)");
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString())).thenReturn((Object)this.preparedStatement);
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)this.preparedStatement);
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString(), (int[])Mockito.any(int[].class))).thenReturn((Object)this.preparedStatement);
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)this.preparedStatement);
    }

    @Test
    public void testDefaultAutoGenerateKeysStrategy() throws SQLException {
        DefaultAutoGenerateKeysStrategy strategy = new DefaultAutoGenerateKeysStrategy();
        Assert.assertTrue((boolean)strategy.returnsAutoGenerateKeys());
        PreparedStatement result = strategy.prepareStatement(this.dbConnection, this.queryTemplate);
        Assert.assertNotNull((Object)result);
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).prepareStatement("INSERT INTO test_table (name) VALUES (?)", 1);
        Mockito.when((Object)this.preparedStatement.execute()).thenReturn((Object)true);
        boolean executeResult = strategy.execute((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertTrue((boolean)executeResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.when((Object)this.statement.execute(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)false);
        boolean statementExecuteResult = strategy.execute(this.statement, this.queryTemplate);
        Assert.assertFalse((boolean)statementExecuteResult);
        ((Statement)Mockito.verify((Object)this.statement)).execute("INSERT INTO test_table (name) VALUES (?)", 1);
        Mockito.when((Object)this.preparedStatement.executeUpdate()).thenReturn((Object)1);
        int updateResult = strategy.executeUpdate((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)updateResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).executeUpdate();
        Mockito.when((Object)this.statement.executeUpdate(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)1);
        int statementUpdateResult = strategy.executeUpdate(this.statement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)statementUpdateResult);
        ((Statement)Mockito.verify((Object)this.statement)).executeUpdate("INSERT INTO test_table (name) VALUES (?)", 1);
    }

    @Test
    public void testNoAutoGenerateKeysStrategy() throws SQLException {
        NoAutoGenerateKeysStrategy strategy = new NoAutoGenerateKeysStrategy();
        Assert.assertFalse((boolean)strategy.returnsAutoGenerateKeys());
        PreparedStatement result = strategy.prepareStatement(this.dbConnection, this.queryTemplate);
        Assert.assertNotNull((Object)result);
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).prepareStatement("INSERT INTO test_table (name) VALUES (?)");
        Mockito.when((Object)this.preparedStatement.execute()).thenReturn((Object)true);
        boolean executeResult = strategy.execute((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertTrue((boolean)executeResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.when((Object)this.statement.execute(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)false);
        boolean statementExecuteResult = strategy.execute(this.statement, this.queryTemplate);
        Assert.assertFalse((boolean)statementExecuteResult);
        ((Statement)Mockito.verify((Object)this.statement)).execute("INSERT INTO test_table (name) VALUES (?)", 2);
        Mockito.when((Object)this.preparedStatement.executeUpdate()).thenReturn((Object)1);
        int updateResult = strategy.executeUpdate((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)updateResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).executeUpdate();
        Mockito.when((Object)this.statement.executeUpdate(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)1);
        int statementUpdateResult = strategy.executeUpdate(this.statement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)statementUpdateResult);
        ((Statement)Mockito.verify((Object)this.statement)).executeUpdate("INSERT INTO test_table (name) VALUES (?)", 2);
    }

    @Test
    public void testColumnIndexAutoGenerateKeysStrategy() throws SQLException {
        int[] columnIndexes = new int[]{1, 2, 3};
        ColumnIndexAutoGenerateKeysStrategy strategy = new ColumnIndexAutoGenerateKeysStrategy(columnIndexes);
        Assert.assertTrue((boolean)strategy.returnsAutoGenerateKeys());
        PreparedStatement result = strategy.prepareStatement(this.dbConnection, this.queryTemplate);
        Assert.assertNotNull((Object)result);
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).prepareStatement("INSERT INTO test_table (name) VALUES (?)", columnIndexes);
        Mockito.when((Object)this.preparedStatement.execute()).thenReturn((Object)true);
        boolean executeResult = strategy.execute((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertTrue((boolean)executeResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.when((Object)this.statement.execute(Mockito.anyString(), (int[])Mockito.any(int[].class))).thenReturn((Object)false);
        boolean statementExecuteResult = strategy.execute(this.statement, this.queryTemplate);
        Assert.assertFalse((boolean)statementExecuteResult);
        ((Statement)Mockito.verify((Object)this.statement)).execute("INSERT INTO test_table (name) VALUES (?)", columnIndexes);
        Mockito.when((Object)this.preparedStatement.executeUpdate()).thenReturn((Object)1);
        int updateResult = strategy.executeUpdate((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)updateResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).executeUpdate();
        Mockito.when((Object)this.statement.executeUpdate(Mockito.anyString(), (int[])Mockito.any(int[].class))).thenReturn((Object)1);
        int statementUpdateResult = strategy.executeUpdate(this.statement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)statementUpdateResult);
        ((Statement)Mockito.verify((Object)this.statement)).executeUpdate("INSERT INTO test_table (name) VALUES (?)", columnIndexes);
    }

    @Test
    public void testColumnNameAutoGenerateKeysStrategy() throws SQLException {
        String[] columnNames = new String[]{"id", "name", "email"};
        ColumnNameAutoGenerateKeysStrategy strategy = new ColumnNameAutoGenerateKeysStrategy(columnNames);
        Assert.assertTrue((boolean)strategy.returnsAutoGenerateKeys());
        PreparedStatement result = strategy.prepareStatement(this.dbConnection, this.queryTemplate);
        Assert.assertNotNull((Object)result);
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).prepareStatement("INSERT INTO test_table (name) VALUES (?)", columnNames);
        Mockito.when((Object)this.preparedStatement.execute()).thenReturn((Object)true);
        boolean executeResult = strategy.execute((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertTrue((boolean)executeResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).execute();
        Mockito.when((Object)this.statement.execute(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)false);
        boolean statementExecuteResult = strategy.execute(this.statement, this.queryTemplate);
        Assert.assertFalse((boolean)statementExecuteResult);
        ((Statement)Mockito.verify((Object)this.statement)).execute("INSERT INTO test_table (name) VALUES (?)", columnNames);
        Mockito.when((Object)this.preparedStatement.executeUpdate()).thenReturn((Object)1);
        int updateResult = strategy.executeUpdate((Statement)this.preparedStatement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)updateResult);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatement)).executeUpdate();
        Mockito.when((Object)this.statement.executeUpdate(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)1);
        int statementUpdateResult = strategy.executeUpdate(this.statement, this.queryTemplate);
        Assert.assertEquals((long)1L, (long)statementUpdateResult);
        ((Statement)Mockito.verify((Object)this.statement)).executeUpdate("INSERT INTO test_table (name) VALUES (?)", columnNames);
    }

    @Test
    public void testColumnIndexAutoGenerateKeysStrategyWithEmptyArray() throws SQLException {
        int[] columnIndexes = new int[]{};
        ColumnIndexAutoGenerateKeysStrategy strategy = new ColumnIndexAutoGenerateKeysStrategy(columnIndexes);
        Assert.assertTrue((boolean)strategy.returnsAutoGenerateKeys());
        PreparedStatement result = strategy.prepareStatement(this.dbConnection, this.queryTemplate);
        Assert.assertNotNull((Object)result);
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).prepareStatement("INSERT INTO test_table (name) VALUES (?)", columnIndexes);
    }

    @Test
    public void testColumnNameAutoGenerateKeysStrategyWithEmptyArray() throws SQLException {
        String[] columnNames = new String[]{};
        ColumnNameAutoGenerateKeysStrategy strategy = new ColumnNameAutoGenerateKeysStrategy(columnNames);
        Assert.assertTrue((boolean)strategy.returnsAutoGenerateKeys());
        PreparedStatement result = strategy.prepareStatement(this.dbConnection, this.queryTemplate);
        Assert.assertNotNull((Object)result);
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).prepareStatement("INSERT INTO test_table (name) VALUES (?)", columnNames);
    }

    @Test(expected=SQLException.class)
    public void testDefaultAutoGenerateKeysStrategyPrepareStatementThrowsSQLException() throws SQLException {
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString(), Mockito.anyInt())).thenThrow(new Throwable[]{new SQLException("Database error")});
        DefaultAutoGenerateKeysStrategy strategy = new DefaultAutoGenerateKeysStrategy();
        strategy.prepareStatement(this.dbConnection, this.queryTemplate);
    }

    @Test(expected=SQLException.class)
    public void testNoAutoGenerateKeysStrategyPrepareStatementThrowsSQLException() throws SQLException {
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString())).thenThrow(new Throwable[]{new SQLException("Database error")});
        NoAutoGenerateKeysStrategy strategy = new NoAutoGenerateKeysStrategy();
        strategy.prepareStatement(this.dbConnection, this.queryTemplate);
    }

    @Test(expected=SQLException.class)
    public void testColumnIndexAutoGenerateKeysStrategyPrepareStatementThrowsSQLException() throws SQLException {
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString(), (int[])Mockito.any(int[].class))).thenThrow(new Throwable[]{new SQLException("Database error")});
        ColumnIndexAutoGenerateKeysStrategy strategy = new ColumnIndexAutoGenerateKeysStrategy(new int[]{1});
        strategy.prepareStatement(this.dbConnection, this.queryTemplate);
    }

    @Test(expected=SQLException.class)
    public void testColumnNameAutoGenerateKeysStrategyPrepareStatementThrowsSQLException() throws SQLException {
        Mockito.when((Object)this.jdbcConnection.prepareStatement(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenThrow(new Throwable[]{new SQLException("Database error")});
        ColumnNameAutoGenerateKeysStrategy strategy = new ColumnNameAutoGenerateKeysStrategy(new String[]{"id"});
        strategy.prepareStatement(this.dbConnection, this.queryTemplate);
    }

    @Test(expected=SQLException.class)
    public void testDefaultAutoGenerateKeysStrategyExecuteThrowsSQLException() throws SQLException {
        Mockito.when((Object)this.statement.execute(Mockito.anyString(), Mockito.anyInt())).thenThrow(new Throwable[]{new SQLException("Database error")});
        DefaultAutoGenerateKeysStrategy strategy = new DefaultAutoGenerateKeysStrategy();
        strategy.execute(this.statement, this.queryTemplate);
    }

    @Test(expected=SQLException.class)
    public void testDefaultAutoGenerateKeysStrategyExecuteUpdateThrowsSQLException() throws SQLException {
        Mockito.when((Object)this.statement.executeUpdate(Mockito.anyString(), Mockito.anyInt())).thenThrow(new Throwable[]{new SQLException("Database error")});
        DefaultAutoGenerateKeysStrategy strategy = new DefaultAutoGenerateKeysStrategy();
        strategy.executeUpdate(this.statement, this.queryTemplate);
    }
}

