/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import java.lang.reflect.Field;
import java.sql.Array;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.api.DbAggregate;
import org.mule.db.commons.internal.DbFunctionUtil;
import org.mule.db.commons.internal.DbFunctions;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.extension.ExtensionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class DbFunctionsTestCase {
    @Mock
    private ExtensionManager mockExtensionManager;
    @Mock
    private DbFunctionUtil mockUtil;
    private DbFunctions dbFunctions;

    @Before
    public void setUp() throws InitialisationException {
        this.dbFunctions = new DbFunctions();
        try {
            Field utilField = DbFunctions.class.getDeclaredField("util");
            utilField.setAccessible(true);
            utilField.set(this.dbFunctions, this.mockUtil);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to inject mock util", e);
        }
    }

    @Test
    public void testInitialise() throws InitialisationException {
        this.dbFunctions.initialise();
    }

    @Test
    public void testCreateArraySuccess() throws Exception {
        String configName = "testConfig";
        String typeName = "test_array_type";
        List<Object> values = Arrays.asList("value1", "value2", "value3");
        Array mockArray = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenReturn((Object)mockArray);
        Object result = this.dbFunctions.createArray(configName, typeName, values);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)mockArray, (Object)result);
        ((DbFunctionUtil)Mockito.verify((Object)this.mockUtil)).execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName));
    }

    @Test
    public void testCreateArrayWithException() throws Exception {
        String configName = "testConfig";
        String typeName = "test_array_type";
        List<Object> values = Arrays.asList("value1", "value2");
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenThrow(new Throwable[]{new RuntimeException("Database error")});
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctions.createArray(configName, typeName, values));
        Assert.assertTrue((boolean)exception.getMessage().contains("An error occurred when trying to create SQL array"));
        Assert.assertTrue((boolean)exception.getMessage().contains(typeName));
        Assert.assertTrue((boolean)exception.getMessage().contains("Database error"));
    }

    @Test
    public void testCreateArrayWithEmptyValues() throws Exception {
        String configName = "testConfig";
        String typeName = "test_array_type";
        List<Object> values = Arrays.asList(new Object[0]);
        Array mockArray = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenReturn((Object)mockArray);
        Object result = this.dbFunctions.createArray(configName, typeName, values);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)mockArray, (Object)result);
    }

    @Test
    public void testCreateArrayWithNullValues() throws Exception {
        String configName = "testConfig";
        String typeName = "test_array_type";
        List<Object> values = Arrays.asList(null, "value2", null);
        Array mockArray = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenReturn((Object)mockArray);
        Object result = this.dbFunctions.createArray(configName, typeName, values);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)mockArray, (Object)result);
    }

    @Test
    public void testPrepareArray() {
        String typeName = "test_array_type";
        List<Object> values = Arrays.asList("value1", "value2", "value3");
        Object result = this.dbFunctions.prepareArray(typeName, values);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DbAggregate));
        DbAggregate aggregate = (DbAggregate)result;
        Assert.assertEquals((Object)DbAggregate.Kind.ARRAY, (Object)aggregate.getKind());
        Assert.assertEquals((Object)typeName, (Object)aggregate.getTypeName());
        Assert.assertEquals(values, (Object)aggregate);
    }

    @Test
    public void testPrepareArrayWithEmptyValues() {
        String typeName = "test_array_type";
        List<Object> values = Arrays.asList(new Object[0]);
        Object result = this.dbFunctions.prepareArray(typeName, values);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DbAggregate));
        DbAggregate aggregate = (DbAggregate)result;
        Assert.assertEquals((Object)DbAggregate.Kind.ARRAY, (Object)aggregate.getKind());
        Assert.assertEquals((Object)typeName, (Object)aggregate.getTypeName());
        Assert.assertEquals(values, (Object)aggregate);
    }

    @Test
    public void testCreateStructSuccess() throws Exception {
        String configName = "testConfig";
        String typeName = "test_struct_type";
        List<Object> properties = Arrays.asList("prop1", "prop2", "prop3");
        Struct mockStruct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenReturn((Object)mockStruct);
        Object result = this.dbFunctions.createStruct(configName, typeName, properties);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)mockStruct, (Object)result);
        ((DbFunctionUtil)Mockito.verify((Object)this.mockUtil)).execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName));
    }

    @Test
    public void testCreateStructWithException() throws Exception {
        String configName = "testConfig";
        String typeName = "test_struct_type";
        List<Object> properties = Arrays.asList("prop1", "prop2");
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenThrow(new Throwable[]{new RuntimeException("Database error")});
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctions.createStruct(configName, typeName, properties));
        Assert.assertTrue((boolean)exception.getMessage().contains("An error occurred when trying to create SQL struct"));
        Assert.assertTrue((boolean)exception.getMessage().contains(typeName));
        Assert.assertTrue((boolean)exception.getMessage().contains("Database error"));
    }

    @Test
    public void testCreateStructWithEmptyProperties() throws Exception {
        String configName = "testConfig";
        String typeName = "test_struct_type";
        List<Object> properties = Arrays.asList(new Object[0]);
        Struct mockStruct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenReturn((Object)mockStruct);
        Object result = this.dbFunctions.createStruct(configName, typeName, properties);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)mockStruct, (Object)result);
    }

    @Test
    public void testCreateStructWithNullProperties() throws Exception {
        String configName = "testConfig";
        String typeName = "test_struct_type";
        List<Object> properties = Arrays.asList(null, "prop2", null);
        Struct mockStruct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq((Object)configName))).thenReturn((Object)mockStruct);
        Object result = this.dbFunctions.createStruct(configName, typeName, properties);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)mockStruct, (Object)result);
    }

    @Test
    public void testPrepareStruct() {
        String typeName = "test_struct_type";
        List<Object> properties = Arrays.asList("prop1", "prop2", "prop3");
        Object result = this.dbFunctions.prepareStruct(typeName, properties);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DbAggregate));
        DbAggregate aggregate = (DbAggregate)result;
        Assert.assertEquals((Object)DbAggregate.Kind.STRUCT, (Object)aggregate.getKind());
        Assert.assertEquals((Object)typeName, (Object)aggregate.getTypeName());
        Assert.assertEquals(properties, (Object)aggregate);
    }

    @Test
    public void testPrepareStructWithEmptyProperties() {
        String typeName = "test_struct_type";
        List<Object> properties = Arrays.asList(new Object[0]);
        Object result = this.dbFunctions.prepareStruct(typeName, properties);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DbAggregate));
        DbAggregate aggregate = (DbAggregate)result;
        Assert.assertEquals((Object)DbAggregate.Kind.STRUCT, (Object)aggregate.getKind());
        Assert.assertEquals((Object)typeName, (Object)aggregate.getTypeName());
        Assert.assertEquals(properties, (Object)aggregate);
    }

    @Test
    public void testCreateArrayWithNullConfigName() throws Exception {
        String configName = null;
        String typeName = "test_array_type";
        List<Object> values = Arrays.asList("value1", "value2");
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq(configName))).thenThrow(new Throwable[]{new RuntimeException("Config not found")});
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctions.createArray(configName, typeName, values));
        Assert.assertTrue((boolean)exception.getMessage().contains("An error occurred when trying to create SQL array"));
    }

    @Test
    public void testCreateStructWithNullConfigName() throws Exception {
        String configName = null;
        String typeName = "test_struct_type";
        List<Object> properties = Arrays.asList("prop1", "prop2");
        Mockito.when((Object)this.mockUtil.execute((DbFunctionUtil.ConnectedFunction)ArgumentMatchers.any(DbFunctionUtil.ConnectedFunction.class), (String)Mockito.eq(configName))).thenThrow(new Throwable[]{new RuntimeException("Config not found")});
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctions.createStruct(configName, typeName, properties));
        Assert.assertTrue((boolean)exception.getMessage().contains("An error occurred when trying to create SQL struct"));
    }

    @Test
    public void testPrepareArrayWithNullTypeName() {
        String typeName = null;
        List<Object> values = Arrays.asList("value1", "value2");
        Object result = this.dbFunctions.prepareArray(typeName, values);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DbAggregate));
        DbAggregate aggregate = (DbAggregate)result;
        Assert.assertEquals((Object)DbAggregate.Kind.ARRAY, (Object)aggregate.getKind());
        Assert.assertNull((Object)aggregate.getTypeName());
    }

    @Test
    public void testPrepareStructWithNullTypeName() {
        String typeName = null;
        List<Object> properties = Arrays.asList("prop1", "prop2");
        Object result = this.dbFunctions.prepareStruct(typeName, properties);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DbAggregate));
        DbAggregate aggregate = (DbAggregate)result;
        Assert.assertEquals((Object)DbAggregate.Kind.STRUCT, (Object)aggregate.getKind());
        Assert.assertNull((Object)aggregate.getTypeName());
    }
}

