/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.result.statement;

import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;

import java.sql.Statement;

/**
 * Creates {@link StatementResultIterator} for generic database configurations
 */
public class GenericStatementResultIteratorFactory implements StatementResultIteratorFactory {

  private final ResultSetHandler resultSetHandler;

  public GenericStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
    this.resultSetHandler = resultSetHandler;
  }

  @Override
  public final StatementResultIterator create(DbConnection connection, Statement statement, QueryTemplate queryTemplate,
                                              AutoGenerateKeysStrategy autoGenerateKeysStrategy) {
    return doCreateStatementResultIterator(connection, statement, queryTemplate, autoGenerateKeysStrategy, resultSetHandler);
  }

  protected StatementResultIterator doCreateStatementResultIterator(DbConnection connection, Statement statement,
                                                                    QueryTemplate queryTemplate,
                                                                    AutoGenerateKeysStrategy autoGenerateKeysStrategy,
                                                                    ResultSetHandler resultSetHandler) {
    return new StatementResultIterator(connection, statement, queryTemplate, autoGenerateKeysStrategy, resultSetHandler);
  }
}
