/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.type;

import org.mule.db.commons.internal.domain.connection.DbConnection;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Defines a specialized data type for TIMESTAMP WITH TIME ZONE (Oracle type -102) This class provides special handling for
 * timestamp values with timezone information.
 */
public class TimestampWithTimeZoneDbType extends AbstractDbType {

  public static final int ORACLE_TIMESTAMP_WITH_TIME_ZONE_ID = -102;

  public TimestampWithTimeZoneDbType(int id, String name) {
    super(id, name);
  }

  @Override
  public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection)
      throws SQLException {
    if (value == null) {
      statement.setNull(index, id);
      return;
    }
    statement.setObject(index, value);
  }

  @Override
  public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
    return statement.getObject(index);
  }
}
