/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import static org.mule.db.commons.internal.domain.connection.enhydra.wrappers.EnhydraWrapperUtils.setTLSProperties;
import static org.mule.db.commons.internal.util.ClassUtils.getFieldValue;

import org.enhydra.jdbc.standard.StandardDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.mule.runtime.api.tls.TlsContextFactory;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

/**
 * Wrapper class for Enhydra' {@link StandardXADataSource} to modify its behaviour.
 *
 * @since 1.3.0
 */
public class StandardXADataSourceWrapper extends StandardXADataSource {

  private final transient TlsContextFactory tlsContextFactory;
  private final AbstractDataSourceWrapper abstractDataSourceWrapper;

  public StandardXADataSourceWrapper(TlsContextFactory tlsContextFactory) {
    super();
    this.tlsContextFactory = tlsContextFactory;
    abstractDataSourceWrapper = new AbstractDataSourceWrapper();
  }

  @Override
  public synchronized Connection getConnection(String user, String password) throws SQLException {
    return abstractDataSourceWrapper.getSecureConnectionIfPossible(user, password, this, this.tlsContextFactory);
  }

}
