/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.Struct;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.StructDbType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StructDbTypeTestCase
extends AbstractMuleTestCase {
    private static final int PARAM_INDEX = 1;
    private static final String TYPE_NAME = "testStruct";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private StructDbType dataType;
    private PreparedStatement statement;
    private Connection connection;
    private DbConnection dbConnection;
    private Struct struct;
    private DatabaseMetaData databaseMetaData;

    @Before
    public void setUp() throws Exception {
        this.dataType = new StructDbType(2002, TYPE_NAME);
        this.statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.struct = (Struct)Mockito.mock(Struct.class);
        this.databaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)this.statement.getConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.getMetaData()).thenReturn((Object)this.databaseMetaData);
        Mockito.when((Object)this.databaseMetaData.getDriverName()).thenReturn((Object)"JDBC Driver");
    }

    @Test
    public void convertsArrayToStruct() throws Exception {
        Object[] value = new Object[]{"foo", "bar"};
        Mockito.when((Object)this.connection.createStruct(TYPE_NAME, value)).thenReturn((Object)this.struct);
        this.dataType.setParameterValue(this.statement, 1, (Object)value, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)this.struct, 2002);
    }

    @Test
    public void convertsListToStruct() throws Exception {
        ArrayList<String> value = new ArrayList<String>();
        value.add("foo");
        value.add("bar");
        Mockito.when((Object)this.connection.createStruct((String)MockitoHamcrest.argThat((Matcher)Matchers.equalTo((Object)TYPE_NAME)), (Object[])MockitoHamcrest.argThat((Matcher)Matchers.arrayContaining((Object[])new String[]{"foo", "bar"})))).thenReturn((Object)this.struct);
        this.dataType.setParameterValue(this.statement, 1, value, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)this.struct, 2002);
    }
}

