/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Connection;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;

public class DefaultDbConnectionTest {
    private static final long CACHE_MAXIMUM_SIZE = 1000L;

    @Test
    public void createConnectionWithValidCacheSize() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DefaultDbConnection defaultDbConnection = new DefaultDbConnection(connection, new ArrayList(), Caffeine.newBuilder().maximumSize(1000L).build());
        Assert.assertNotNull((Object)defaultDbConnection);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createConnectionWithInvalidCacheSize() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        new DefaultDbConnection(connection, new ArrayList(), Caffeine.newBuilder().maximumSize(-1000L).build());
    }

    @Test
    public void createConnectionWithZeroValue() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DefaultDbConnection defaultDbConnection = new DefaultDbConnection(connection, new ArrayList(), Caffeine.newBuilder().maximumSize(0L).build());
        Assert.assertNotNull((Object)defaultDbConnection);
    }

    @Test
    public void createConnectionWithDefaultCache() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DefaultDbConnection defaultDbConnection = new DefaultDbConnection(connection, new ArrayList());
        Assert.assertNotNull((Object)defaultDbConnection);
    }
}

