/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.db.commons.internal.util.StoredProcedureUtils;
import org.mule.runtime.api.util.Pair;

public class StoredProcedureUtilsTestCase {
    @Test
    public void validExpressionStoredProcedure() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.procedure()}");
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void validExpressionWithDollarCharacterProcedure() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.proce$dures()}");
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
        result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.procedure$()}");
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
        result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.$procedure()}");
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void validExpressionBracketsStoredProcedure() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call [db].[procedure]()}");
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void invalidExpressionStoredProcedure() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call [db].procedu{re()}");
    }

    @Test
    public void validExpressionFunction() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call db.funcion()}");
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void validExpressionBracketsFunction() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call [db].[funcion]()}");
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void invalidExpressionFunction() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call [db].func{ion()}");
    }
}

