/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.internal.AbstractDbFunctionTestCase;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;

public class CreateStructTestCase
extends AbstractDbFunctionTestCase {
    @Test
    public void createStructResolvingBlobInDefaultDbConnection() throws Exception {
        Object[] structValues = new Object[]{"foo", "bar"};
        Connection delegate = (Connection)Mockito.mock(Connection.class);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)delegate.createBlob()).thenReturn((Object)blob);
        DefaultDbConnection defaultDbConnection = this.mockDefaultDbConnectionMetadata(delegate, JdbcType.BLOB.getDbType().getId(), JdbcType.BLOB.getDbType().getName());
        defaultDbConnection.createStruct("TEST_ARRAY", structValues);
        ((Connection)Mockito.verify((Object)delegate)).createStruct("TEST_ARRAY", structValues);
        MatcherAssert.assertThat((Object)structValues[0], (Matcher)Matchers.equalTo((Object)blob));
    }

    @Test
    public void createStructResolvingClobInDefaultDbConnection() throws Exception {
        Object[] structValues = new Object[]{"foo", "bar"};
        Connection delegate = (Connection)Mockito.mock(Connection.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        Mockito.when((Object)delegate.createClob()).thenReturn((Object)clob);
        DefaultDbConnection defaultDbConnection = this.mockDefaultDbConnectionMetadata(delegate, JdbcType.CLOB.getDbType().getId(), JdbcType.CLOB.getDbType().getName());
        defaultDbConnection.createStruct("TEST_ARRAY", structValues);
        ((Connection)Mockito.verify((Object)delegate)).createStruct("TEST_ARRAY", structValues);
        MatcherAssert.assertThat((Object)structValues[0], (Matcher)Matchers.equalTo((Object)clob));
    }
}

