/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.internal.AbstractDbFunctionTestCase;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;

public class CreateArrayTestCase
extends AbstractDbFunctionTestCase {
    @Test
    public void createsDbArrayResolvingClobWithDefaultConnection() throws Exception {
        Object[] structValues = new Object[]{"clob", "foo"};
        Object[] structValues1 = new Object[]{"clob1", "foo1"};
        Object[] params = new Object[]{structValues, structValues1};
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        Mockito.when((Object)connection.createClob()).thenReturn((Object)clob);
        Array array = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)connection.createArrayOf("TEST_ARRAY", params)).thenReturn((Object)array);
        DefaultDbConnection defaultDbConnection = this.mockDefaultDbConnectionMetadata(connection, JdbcType.CLOB.getDbType().getId(), JdbcType.CLOB.getDbType().getName());
        defaultDbConnection.createArrayOf("TEST_ARRAY", params);
        ((Connection)Mockito.verify((Object)connection)).createArrayOf("TEST_ARRAY", params);
        MatcherAssert.assertThat((Object)((Object[])params[0])[0], (Matcher)Matchers.equalTo((Object)clob));
        MatcherAssert.assertThat((Object)((Object[])params[1])[0], (Matcher)Matchers.equalTo((Object)clob));
    }

    @Test
    public void createsDbArrayResolvingBlobWithDefaultConnection() throws Exception {
        Object[] structValues = new Object[]{"blob", "foo"};
        Object[] structValues1 = new Object[]{"blob1", "foo1"};
        Object[] params = new Object[]{structValues, structValues1};
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)connection.createBlob()).thenReturn((Object)blob);
        Array array = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)connection.createArrayOf("TEST_ARRAY", params)).thenReturn((Object)array);
        DefaultDbConnection defaultDbConnection = this.mockDefaultDbConnectionMetadata(connection, JdbcType.BLOB.getDbType().getId(), JdbcType.BLOB.getDbType().getName());
        defaultDbConnection.createArrayOf("TEST_ARRAY", params);
        ((Connection)Mockito.verify((Object)connection)).createArrayOf("TEST_ARRAY", params);
        MatcherAssert.assertThat((Object)((Object[])params[0])[0], (Matcher)Matchers.equalTo((Object)blob));
        MatcherAssert.assertThat((Object)((Object[])params[1])[0], (Matcher)Matchers.equalTo((Object)blob));
    }

    @Test
    public void createsDbArrayResolvingBlobWithDefaultCache() throws Exception {
        Object[] structValues = new Object[]{"blob", "foo"};
        Object[] structValues1 = new Object[]{"blob1", "foo1"};
        Object[] params = new Object[]{structValues, structValues1};
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)connection.createBlob()).thenReturn((Object)blob);
        Array array = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)connection.createArrayOf("TEST_ARRAY", params)).thenReturn((Object)array);
        DefaultDbConnection defaultDbConnection = this.mockDefaultDbConnectionMetadataWithDefaultCache(connection, JdbcType.BLOB.getDbType().getId(), JdbcType.BLOB.getDbType().getName());
        defaultDbConnection.createArrayOf("TEST_ARRAY", params);
        ((Connection)Mockito.verify((Object)connection)).createArrayOf("TEST_ARRAY", params);
        MatcherAssert.assertThat((Object)((Object[])params[0])[0], (Matcher)Matchers.equalTo((Object)blob));
        MatcherAssert.assertThat((Object)((Object[])params[1])[0], (Matcher)Matchers.equalTo((Object)blob));
    }
}

