/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.UnknownDbTypeException;

public class StaticDbTypeManager
implements DbTypeManager {
    private Map<String, DbType> nameVendorTypesMap = new HashMap<String, DbType>();
    private Map<String, DbType> nameAndIdVendorTypesMap = new HashMap<String, DbType>();

    public StaticDbTypeManager(List<DbType> vendorTypes) {
        for (DbType vendorType : vendorTypes) {
            this.nameAndIdVendorTypesMap.put(vendorType.getName() + vendorType.getId(), vendorType);
            this.nameVendorTypesMap.put(vendorType.getName(), vendorType);
        }
    }

    @Override
    public DbType lookup(DbConnection connection, int id, String name) throws UnknownDbTypeException {
        if (this.nameAndIdVendorTypesMap.containsKey(name + id)) {
            return this.nameAndIdVendorTypesMap.get(name + id);
        }
        throw new UnknownDbTypeException(id, name);
    }

    @Override
    public DbType lookup(DbConnection connection, String name) throws UnknownDbTypeException {
        if (this.nameVendorTypesMap.containsKey(name)) {
            return this.nameVendorTypesMap.get(name);
        }
        throw new UnknownDbTypeException(name);
    }
}

