/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.arrayType;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.connection.type.resolver.ArrayTypeResolver;
import org.mule.db.commons.internal.domain.connection.type.resolver.StructTypeResolver;
import org.mule.db.commons.utils.MockResultSet;

public class StructAndArrayTypeResolverTestCase {
    @Mock
    private DefaultDbConnection connection;
    @Mock
    private Connection jdbcConnection;
    @Mock
    private DatabaseMetaData metadata;
    private static final String INTEGER_TYPE = "Integer";
    private static final String RESOLVED_INTEGER_TYPE = "Integer".toUpperCase();

    @Before
    public void setUp() throws Exception {
        this.metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)this.metadata.storesUpperCaseIdentifiers()).thenReturn((Object)true);
        this.jdbcConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.jdbcConnection.getMetaData()).thenReturn((Object)this.metadata);
        this.connection = (DefaultDbConnection)Mockito.mock(DefaultDbConnection.class);
        Mockito.when((Object)this.connection.getJdbcConnection()).thenReturn((Object)this.jdbcConnection);
    }

    @Test
    public void whenCorrectTypeNameResolveArrayType() throws SQLException {
        ArrayTypeResolver resolver = new ArrayTypeResolver(this.connection);
        Mockito.when((Object)this.connection.prepareStatement((String)ArgumentMatchers.any())).thenReturn((Object)this.getTypesPreparedStatement());
        String notCachedArrayType = resolver.resolveType(INTEGER_TYPE);
        Assert.assertTrue((notCachedArrayType == RESOLVED_INTEGER_TYPE ? 1 : 0) != 0);
    }

    @Test
    public void whenCorrectTypeNameResolveStructType() throws SQLException {
        StructTypeResolver resolver = new StructTypeResolver(this.connection);
        Mockito.when((Object)this.connection.prepareStatement((String)ArgumentMatchers.any())).thenReturn((Object)this.getTypesPreparedStatement());
        String notCachedArrayType = resolver.resolveType(INTEGER_TYPE);
        Assert.assertTrue((notCachedArrayType == INTEGER_TYPE ? 1 : 0) != 0);
    }

    @Test
    public void whenCorrectTypeNameResolveArrayTypeFromCache() throws SQLException {
        ConcurrentHashMap arrayTypeCache = new ConcurrentHashMap();
        ArrayTypeResolver resolver = new ArrayTypeResolver(this.connection);
        Mockito.when((Object)this.connection.prepareStatement((String)ArgumentMatchers.any())).thenReturn((Object)this.getTypesPreparedStatement());
        String notCachedArrayType = resolver.resolveType(INTEGER_TYPE, arrayTypeCache);
        String cachedArrayType = resolver.resolveType(INTEGER_TYPE, arrayTypeCache);
        Assert.assertTrue((notCachedArrayType == RESOLVED_INTEGER_TYPE ? 1 : 0) != 0);
        Assert.assertTrue((cachedArrayType == RESOLVED_INTEGER_TYPE ? 1 : 0) != 0);
        Assert.assertTrue((arrayTypeCache.size() == 1 ? 1 : 0) != 0);
    }

    private PreparedStatement getTypesPreparedStatement() {
        return new PreparedStatement(){

            @Override
            public ResultSet executeQuery() throws SQLException {
                return StructAndArrayTypeResolverTestCase.this.createResultSet();
            }

            @Override
            public int executeUpdate() throws SQLException {
                return 0;
            }

            @Override
            public void setNull(int parameterIndex, int sqlType) throws SQLException {
            }

            @Override
            public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            }

            @Override
            public void setByte(int parameterIndex, byte x) throws SQLException {
            }

            @Override
            public void setShort(int parameterIndex, short x) throws SQLException {
            }

            @Override
            public void setInt(int parameterIndex, int x) throws SQLException {
            }

            @Override
            public void setLong(int parameterIndex, long x) throws SQLException {
            }

            @Override
            public void setFloat(int parameterIndex, float x) throws SQLException {
            }

            @Override
            public void setDouble(int parameterIndex, double x) throws SQLException {
            }

            @Override
            public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            }

            @Override
            public void setString(int parameterIndex, String x) throws SQLException {
            }

            @Override
            public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            }

            @Override
            public void setDate(int parameterIndex, Date x) throws SQLException {
            }

            @Override
            public void setTime(int parameterIndex, Time x) throws SQLException {
            }

            @Override
            public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            }

            @Override
            public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
            }

            @Override
            public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
            }

            @Override
            public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
            }

            @Override
            public void clearParameters() throws SQLException {
            }

            @Override
            public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
            }

            @Override
            public void setObject(int parameterIndex, Object x) throws SQLException {
            }

            @Override
            public boolean execute() throws SQLException {
                return false;
            }

            @Override
            public void addBatch() throws SQLException {
            }

            @Override
            public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
            }

            @Override
            public void setRef(int parameterIndex, Ref x) throws SQLException {
            }

            @Override
            public void setBlob(int parameterIndex, Blob x) throws SQLException {
            }

            @Override
            public void setClob(int parameterIndex, Clob x) throws SQLException {
            }

            @Override
            public void setArray(int parameterIndex, Array x) throws SQLException {
            }

            @Override
            public ResultSetMetaData getMetaData() throws SQLException {
                return null;
            }

            @Override
            public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
            }

            @Override
            public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
            }

            @Override
            public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
            }

            @Override
            public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
            }

            @Override
            public void setURL(int parameterIndex, URL x) throws SQLException {
            }

            @Override
            public ParameterMetaData getParameterMetaData() throws SQLException {
                return null;
            }

            @Override
            public void setRowId(int parameterIndex, RowId x) throws SQLException {
            }

            @Override
            public void setNString(int parameterIndex, String value) throws SQLException {
            }

            @Override
            public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
            }

            @Override
            public void setNClob(int parameterIndex, NClob value) throws SQLException {
            }

            @Override
            public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
            }

            @Override
            public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
            }

            @Override
            public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
            }

            @Override
            public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
            }

            @Override
            public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
            }

            @Override
            public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
            }

            @Override
            public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
            }

            @Override
            public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
            }

            @Override
            public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
            }

            @Override
            public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
            }

            @Override
            public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
            }

            @Override
            public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
            }

            @Override
            public void setClob(int parameterIndex, Reader reader) throws SQLException {
            }

            @Override
            public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
            }

            @Override
            public void setNClob(int parameterIndex, Reader reader) throws SQLException {
            }

            @Override
            public ResultSet executeQuery(String sql) throws SQLException {
                return null;
            }

            @Override
            public int executeUpdate(String sql) throws SQLException {
                return 0;
            }

            @Override
            public void close() throws SQLException {
            }

            @Override
            public int getMaxFieldSize() throws SQLException {
                return 0;
            }

            @Override
            public void setMaxFieldSize(int max) throws SQLException {
            }

            @Override
            public int getMaxRows() throws SQLException {
                return 0;
            }

            @Override
            public void setMaxRows(int max) throws SQLException {
            }

            @Override
            public void setEscapeProcessing(boolean enable) throws SQLException {
            }

            @Override
            public int getQueryTimeout() throws SQLException {
                return 0;
            }

            @Override
            public void setQueryTimeout(int seconds) throws SQLException {
            }

            @Override
            public void cancel() throws SQLException {
            }

            @Override
            public SQLWarning getWarnings() throws SQLException {
                return null;
            }

            @Override
            public void clearWarnings() throws SQLException {
            }

            @Override
            public void setCursorName(String name) throws SQLException {
            }

            @Override
            public boolean execute(String sql) throws SQLException {
                return false;
            }

            @Override
            public ResultSet getResultSet() throws SQLException {
                return null;
            }

            @Override
            public int getUpdateCount() throws SQLException {
                return 0;
            }

            @Override
            public boolean getMoreResults() throws SQLException {
                return false;
            }

            @Override
            public void setFetchDirection(int direction) throws SQLException {
            }

            @Override
            public int getFetchDirection() throws SQLException {
                return 0;
            }

            @Override
            public void setFetchSize(int rows) throws SQLException {
            }

            @Override
            public int getFetchSize() throws SQLException {
                return 0;
            }

            @Override
            public int getResultSetConcurrency() throws SQLException {
                return 0;
            }

            @Override
            public int getResultSetType() throws SQLException {
                return 0;
            }

            @Override
            public void addBatch(String sql) throws SQLException {
            }

            @Override
            public void clearBatch() throws SQLException {
            }

            @Override
            public int[] executeBatch() throws SQLException {
                return new int[0];
            }

            @Override
            public Connection getConnection() throws SQLException {
                return null;
            }

            @Override
            public boolean getMoreResults(int current) throws SQLException {
                return false;
            }

            @Override
            public ResultSet getGeneratedKeys() throws SQLException {
                return null;
            }

            @Override
            public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
                return 0;
            }

            @Override
            public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
                return 0;
            }

            @Override
            public int executeUpdate(String sql, String[] columnNames) throws SQLException {
                return 0;
            }

            @Override
            public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
                return false;
            }

            @Override
            public boolean execute(String sql, int[] columnIndexes) throws SQLException {
                return false;
            }

            @Override
            public boolean execute(String sql, String[] columnNames) throws SQLException {
                return false;
            }

            @Override
            public int getResultSetHoldability() throws SQLException {
                return 0;
            }

            @Override
            public boolean isClosed() throws SQLException {
                return false;
            }

            @Override
            public void setPoolable(boolean poolable) throws SQLException {
            }

            @Override
            public boolean isPoolable() throws SQLException {
                return false;
            }

            @Override
            public void closeOnCompletion() throws SQLException {
            }

            @Override
            public boolean isCloseOnCompletion() throws SQLException {
                return false;
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return false;
            }
        };
    }

    private MockedColumnTypeResultSet createResultSet() {
        ArrayList<Map<Integer, Object>> data = new ArrayList<Map<Integer, Object>>();
        data.add(new HashMap());
        data.add(new HashMap());
        return new MockedColumnTypeResultSet(data);
    }

    private class MockedColumnTypeResultSet
    extends MockResultSet {
        public MockedColumnTypeResultSet(List<Map<Integer, Object>> data) {
            super(data);
        }

        @Override
        public String getString(String columnLabel) throws SQLException {
            return RESOLVED_INTEGER_TYPE;
        }
    }
}

