/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.StoredProcedureStatementTypeDetector;

public class StoredProcedureStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        StoredProcedureStatementTypeDetector detector = new StoredProcedureStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.STORE_PROCEDURE_CALL));
    }

    @Test
    public void validStoredProcedureStatementTest() {
        StoredProcedureStatementTypeDetector detector = new StoredProcedureStatementTypeDetector();
        List<String> spStatements = Arrays.asList("call pepito()", "CALL sp_algo()", "Call SP_ABC");
        for (String statement : spStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidStoredProcedureStatementTest() {
        StoredProcedureStatementTypeDetector detector = new StoredProcedureStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("SELECT * FROM MY TABLE;", "MERGE FROM MYTABLE", "Insert into my table", "UPDATE delete from table");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

