/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import org.enhydra.jdbc.standard.StandardDataSource;

import org.mule.runtime.api.tls.TlsContextFactory;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * Wrapper class for Enhydra' {@link StandardDataSource} to modify its behaviour.
 *
 * @since 1.3.0
 */
public class StandardDataSourceWrapper extends StandardDataSource {

  private final transient TlsContextFactory tlsContextFactory;
  private final AbstractDataSourceWrapper abstractDataSourceWrapper;

  public StandardDataSourceWrapper(TlsContextFactory tlsContextFactory) {
    super();
    this.tlsContextFactory = tlsContextFactory;
    abstractDataSourceWrapper = new AbstractDataSourceWrapper();
  }

  @Override
  public synchronized Connection getConnection(String user, String password) throws SQLException {
    return abstractDataSourceWrapper.getSecureConnectionIfPossible(user, password, this, this.tlsContextFactory);
  }

}
