/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.param;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.DynamicDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.resolver.param.ParamTypeResolver;

public class DefaultParamTypeResolver
implements ParamTypeResolver {
    private final DbTypeManager dbTypeManager;
    private ParamTypeResolver metadataParamTypeResolver;

    DefaultParamTypeResolver(DbTypeManager dbTypeManager, ParamTypeResolver metadataParamTypeResolver) {
        this.dbTypeManager = dbTypeManager;
        this.metadataParamTypeResolver = metadataParamTypeResolver;
    }

    @Override
    public Map<Integer, DbType> getParameterTypes(DbConnection connection, QueryTemplate queryTemplate, List<ParameterType> parameterTypes) {
        HashMap<Integer, DbType> resolvedParamTypes = new HashMap<Integer, DbType>();
        Map<Integer, DbType> metadataParamTypes = null;
        for (QueryParam queryParam : queryTemplate.getParams()) {
            if (queryParam.getType() instanceof UnknownDbType) {
                if (metadataParamTypes == null) {
                    metadataParamTypes = this.getParamTypesUsingMetadata(connection, queryTemplate, parameterTypes);
                }
                resolvedParamTypes.put(queryParam.getIndex(), metadataParamTypes.get(queryParam.getIndex()));
                continue;
            }
            if (queryParam.getType() instanceof DynamicDbType) {
                DbType dbType = this.dbTypeManager.lookup(connection, queryParam.getType().getName());
                resolvedParamTypes.put(queryParam.getIndex(), dbType);
                continue;
            }
            resolvedParamTypes.put(queryParam.getIndex(), queryParam.getType());
        }
        return resolvedParamTypes;
    }

    private Map<Integer, DbType> getParamTypesUsingMetadata(DbConnection connection, QueryTemplate queryTemplate, List<ParameterType> parameterTypes) {
        Map<Integer, DbType> metadataParamTypes;
        try {
            metadataParamTypes = this.metadataParamTypeResolver.getParameterTypes(connection, queryTemplate, parameterTypes);
        }
        catch (SQLException e) {
            metadataParamTypes = this.getParamTypesFromQueryTemplate(queryTemplate);
        }
        return metadataParamTypes;
    }

    private Map<Integer, DbType> getParamTypesFromQueryTemplate(QueryTemplate queryTemplate) {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        for (QueryParam queryParam : queryTemplate.getParams()) {
            paramTypes.put(queryParam.getIndex(), queryParam.getType());
        }
        return paramTypes;
    }
}

