/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import org.mule.db.commons.internal.domain.query.QueryType;

/**
 * Utility class to detect Stored Procedure statements.
 */
public class StoredProcedureStatementTypeDetector extends AbstractStatementTypeDetector {

  private static final String STORED_PROCEDURE_REGEX = "(?ms)(\\{\\s*)?(:\\S+\\s*=)?\\s*CALL\\s* \\s*.*";

  public StoredProcedureStatementTypeDetector() {
    super(QueryType.STORE_PROCEDURE_CALL, STORED_PROCEDURE_REGEX);
  }
}
