/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import org.mule.db.commons.internal.domain.query.QueryType;

/**
 * Utility class to detect a Delete Statement.
 */
public class DeleteStatementTypeDetector extends AbstractStatementTypeDetector {

  private static final String DELETE_REGEX = String.format(OPERATION_REGEX_TEMPLATE, "DELETE");

  public DeleteStatementTypeDetector() {
    super(QueryType.DELETE, DELETE_REGEX);
  }

}
