/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.connection.datasource;

import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.DbConnectionProvider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import javax.sql.DataSource;
import java.util.Optional;

import static org.mule.runtime.extension.api.annotation.param.ParameterGroup.CONNECTION;

/**
 * {@link ConnectionProvider} implementation which creates DB connections from a referenced {@link DataSource} Consumers of
 * {@link DataSourceReferenceConnectionProvider} must create a class similar to this one with the appropriate annotations
 * (DisplayName, Alias, ExternalLib, ParameterGroup, others), and have an instance of this one to pass the required properties.
 */
public class DataSourceReferenceConnectionProvider extends DbConnectionProvider {

  @ParameterGroup(name = CONNECTION)
  private DefaultDatasourceConnectionSettings connectionSettings;

  @Override
  public Optional<DataSource> getDataSource() {
    return Optional.ofNullable(connectionSettings.getDataSourceRef());
  }

  @Override
  public Optional<DataSourceConfig> getDataSourceConfig() {
    return Optional.empty();
  }
}
