/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.api.param;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * The definition of a bulk operations defined around one single SQL command
 *
 * @since 1.0
 */
public class BulkQueryDefinition extends StatementDefinition<BulkQueryDefinition> {


  /**
   * Creates a new instance of BulkQueryDefinition
   */
  public BulkQueryDefinition() {

  }


  /**
   * Creates a new instance of StatementDefinition with the given arguments.
   *
   * @param sql              The text of the SQL query to be executed
   * @param parameterTypes   Allows to optionally specify the type of one or more of the parameters in the query. If provided,
   *                         you're not even required to reference all of the parameters, but you cannot reference a parameter not
   *                         present in the input values
   * @param queryTimeout     Indicates the minimum amount of time before the JDBC driver attempts to cancel a running statement.
   *                         No timeout is used by default.
   * @param queryTimeoutUnit A {@link TimeUnit} which qualifies the {@link #queryTimeout}
   * @param fetchSize        Indicates how many rows to fetch from the database when rows are read from a resultSet.
   * @param maxRows          * Sets the limit for the maximum number of rows that any ResultSet object generated by this message
   *                         processor can contain for the given number. If the limit is exceeded, the excess rows are silently
   *                         dropped.
   */
  public BulkQueryDefinition(String sql, List<ParameterType> parameterTypes, int queryTimeout, TimeUnit queryTimeoutUnit,
                             Integer fetchSize, Integer maxRows) {
    super(sql, parameterTypes, queryTimeout, queryTimeoutUnit, fetchSize, maxRows);
  }



}
