/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.util;

import org.apache.commons.collections.map.AbstractLinkedMap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class CaseInsensitiveLinkedMap<K, V> implements Map<K, V>, Serializable {

  private final CaseInsensitiveLinkedMap.InternalCaseInsensitiveHashMap delegate;

  public CaseInsensitiveLinkedMap() {
    this.delegate = new CaseInsensitiveLinkedMap.InternalCaseInsensitiveHashMap();
  }

  public CaseInsensitiveLinkedMap(Map map) {
    this.delegate = new CaseInsensitiveLinkedMap.InternalCaseInsensitiveHashMap(map);
  }

  public Object clone() {
    return new CaseInsensitiveLinkedMap((Map) this.delegate.clone());
  }

  public int size() {
    return this.delegate.size();
  }

  public boolean isEmpty() {
    return this.delegate.isEmpty();
  }

  public boolean containsKey(Object key) {
    return this.delegate.containsKey(key);
  }

  public boolean containsValue(Object value) {
    return this.delegate.containsValue(value);
  }

  public V get(Object key) {
    return (V) this.delegate.get(key);
  }

  public V put(K key, V value) {
    return (V) this.delegate.put(key, value);
  }

  public V remove(Object key) {
    return (V) this.delegate.remove(key);
  }

  public void putAll(Map<? extends K, ? extends V> values) {
    this.delegate.putAll(values);
  }

  public void clear() {
    this.delegate.clear();
  }

  public Set<K> keySet() {
    return this.delegate.keySet();
  }

  public Collection<V> values() {
    return this.delegate.values();
  }

  public Set<Entry<K, V>> entrySet() {
    return this.delegate.entrySet();
  }

  public String toString() {
    return this.delegate.toString();
  }

  private static class InternalCaseInsensitiveHashMap extends AbstractLinkedMap implements Serializable {

    public InternalCaseInsensitiveHashMap() {
      super(16, 0.75F, 12);
    }

    public InternalCaseInsensitiveHashMap(Map map) {
      super(map);
    }

    protected int hash(Object key) {
      return super.hash(key.toString().toLowerCase());
    }

    protected boolean isEqualKey(Object key1, Object key2) {
      return key1 instanceof String && key2 instanceof String ? ((String) key1).equalsIgnoreCase((String) key2)
          : super.isEqualKey(key1, key2);
    }

    public Object clone() {
      return super.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
      out.defaultWriteObject();
      this.doWriteObject(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
      in.defaultReadObject();
      this.doReadObject(in);
    }
  }
}
