/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.lang.reflect.Field;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Field getField(Class<?> targetClass, String fieldName, boolean recursive) throws NoSuchFieldException {
        Class<?> clazz = targetClass;
        while (!Object.class.equals(clazz)) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (!recursive) break;
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException(String.format("Could not find field '%s' in class %s", fieldName, targetClass.getName()));
    }

    public static <T> T getFieldValue(Object target, String fieldName, boolean recursive) throws IllegalAccessException, NoSuchFieldException {
        Field f = ClassUtils.getField(target.getClass(), fieldName, recursive);
        f.setAccessible(true);
        return (T)f.get(target);
    }
}

