/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.connection.datasource;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import javax.sql.DataSource;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

public class DefaultDatasourceConnectionSettings implements DataSourceConnectionSettings {

  @Parameter
  @Expression(NOT_SUPPORTED)
  private DataSource dataSourceRef;

  @Override
  public DataSource getDataSourceRef() {
    return dataSourceRef;
  }
}


