/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import java.sql.ResultSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.StatementStreamingResultSetCloser;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StatementStreamingResultSetCloserTestCase
extends AbstractMuleTestCase {
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final StatementStreamingResultSetCloser resultSetCloser = new StatementStreamingResultSetCloser(this.connection);
    private final ResultSet resultSet1 = (ResultSet)Mockito.mock(ResultSet.class);
    private final ResultSet resultSet2 = (ResultSet)Mockito.mock(ResultSet.class);

    @After
    public void after() {
        Assert.assertThat((Object)this.resultSetCloser.getOpenResultSets(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void closesRegisteredResultSet() throws Exception {
        this.resultSetCloser.trackResultSet(this.resultSet1);
        this.resultSetCloser.closeResultSets();
        ((ResultSet)Mockito.verify((Object)this.resultSet1)).close();
    }

    @Test
    public void tracksMultipleResultSetFromConnection() throws Exception {
        this.resultSetCloser.trackResultSet(this.resultSet1);
        this.resultSetCloser.trackResultSet(this.resultSet2);
        this.resultSetCloser.closeResultSets();
        ((ResultSet)Mockito.verify((Object)this.resultSet1)).close();
        ((ResultSet)Mockito.verify((Object)this.resultSet2)).close();
    }
}

