/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.http;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.oauth.client.internal.http.DefaultHttpClientFactory;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.tck.probe.PollingProber;

@Feature(value="OAuth Client")
@Story(value="OAuth Dancer")
public class DefaultHttpClientFactoryTestCase {
    private static final int PROBER_TIMEOUT = 5000;
    private static final int PROBER_FREQ = 500;
    private AtomicBoolean clientStarted;
    private Latch startLatch;
    private List<Boolean> startedChecks;
    private TlsContextFactory tlsContextFactory;
    private ProxyConfig proxyConfig;
    private org.mule.oauth.client.api.http.HttpClientFactory oAuthHttpClientFactory;
    private HttpClient httpClient;

    @Before
    public void setup() {
        this.tlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
        this.proxyConfig = (ProxyConfig)Mockito.mock(ProxyConfig.class);
        HttpClientFactory httpClientFactory = (HttpClientFactory)Mockito.mock(HttpClientFactory.class);
        this.httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)httpClientFactory.create((HttpClientConfiguration)ArgumentMatchers.any())).thenReturn((Object)this.httpClient);
        HttpService httpService = (HttpService)Mockito.mock(HttpService.class);
        Mockito.when((Object)httpService.getClientFactory()).thenReturn((Object)httpClientFactory);
        this.oAuthHttpClientFactory = new DefaultHttpClientFactory(httpService);
        this.clientStarted = new AtomicBoolean(false);
        this.startLatch = new Latch();
        this.startedChecks = new ArrayList<Boolean>();
    }

    @Test
    public void createHttpClientWithSameParameterReturnCachedHttpClient() {
        HttpClient client = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)client, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        HttpClient cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Object)client));
    }

    @Test
    public void createHttpClientWithDifferentParametersReturnCachedHttpClient() {
        HttpClient client = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)client, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        HttpClient cachedHttpClient = this.oAuthHttpClientFactory.create(null, null);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
        cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, null);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
        cachedHttpClient = this.oAuthHttpClientFactory.create(null, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
        cachedHttpClient = this.oAuthHttpClientFactory.create((TlsContextFactory)Mockito.mock(TlsContextFactory.class), this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
    }

    @Test
    public void stoppingCachedHttpClientShouldReturnANewHttpClient() {
        HttpClient client = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)client, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        HttpClient cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Object)client));
        client.start();
        client.stop();
        cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
    }

    @Test
    public void callingStartInTheClientMustWaitForItToBeStarted() throws InterruptedException {
        ((HttpClient)Mockito.doAnswer(invocation -> {
            this.startLatch.await(3000L, TimeUnit.MILLISECONDS);
            this.clientStarted.set(true);
            return null;
        }).when((Object)this.httpClient)).start();
        Thread callOne = new Thread(() -> this.getAndStartClient());
        Thread callTwo = new Thread(() -> this.getAndStartClient());
        callOne.start();
        callTwo.start();
        PollingProber.check((long)5000L, (long)500L, () -> this.startedChecks.size() == 2);
        Assert.assertThat((Object)this.startedChecks.get(0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.startedChecks.get(1), (Matcher)Matchers.is((Object)true));
    }

    private void getAndStartClient() {
        HttpClient client = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        client.start();
        this.startLatch.release();
        this.startedChecks.add(this.clientStarted.get());
    }
}

