/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.internal;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.oauth.client.api.AuthorizationCodeOAuthDancer;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.oauth.client.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.internal.builder.DefaultOAuthAuthorizationCodeDancerBuilder;
import org.mule.oauth.client.internal.builder.DefaultOAuthClientCredentialsDancerBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.test.oauth.AbstractOAuthTestCase;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

@Story(value="OAuth Dancer")
public class OAuthContextTestCase
extends AbstractOAuthTestCase {
    protected Map<String, ResourceOwnerOAuthContext> tokensStore;

    @Before
    public void before() throws ConnectionException, IOException, TimeoutException {
        this.tokensStore = new HashMap<String, ResourceOwnerOAuthContext>();
    }

    @Test
    public void clientCredentialsFirstGetContext() throws Exception {
        ClientCredentialsOAuthDancer clientCredentialsDancer = (ClientCredentialsOAuthDancer)this.baseClientCredentialsDancerBuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"default")));
        ResourceOwnerOAuthContext contextFromDancer = clientCredentialsDancer.getContext();
        Assert.assertThat((Object)contextFromDancer, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasEntry((Object)"default", (Object)contextFromDancer));
    }

    @Test
    public void clientCredentialsFollowingGetContext() throws Exception {
        ClientCredentialsOAuthDancer clientCredentialsDancer = (ClientCredentialsOAuthDancer)this.baseClientCredentialsDancerBuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        ResourceOwnerOAuthContext contextFromDancer = clientCredentialsDancer.getContext();
        Assert.assertThat((Object)clientCredentialsDancer.getContext(), (Matcher)Matchers.sameInstance((Object)contextFromDancer));
        Assert.assertThat(this.tokensStore.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void clientCredentialsInvalidateContext() throws Exception {
        ClientCredentialsOAuthDancer clientCredentialsDancer = (ClientCredentialsOAuthDancer)this.baseClientCredentialsDancerBuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"default")));
        clientCredentialsDancer.getContext();
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasKey((Object)"default"));
        clientCredentialsDancer.invalidateContext();
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"default")));
    }

    @Test
    public void authCodeFirstGetContext() throws Exception {
        AuthorizationCodeOAuthDancer authCodeDancer = (AuthorizationCodeOAuthDancer)this.baseAuthCodeDancerbuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"user1")));
        ResourceOwnerOAuthContext contextFromDancer = authCodeDancer.getContextForResourceOwner("user1");
        Assert.assertThat((Object)contextFromDancer, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasEntry((Object)"user1", (Object)contextFromDancer));
    }

    @Test
    public void authCodeFollowingGetContext() throws Exception {
        AuthorizationCodeOAuthDancer authCodeDancer = (AuthorizationCodeOAuthDancer)this.baseAuthCodeDancerbuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        ResourceOwnerOAuthContext contextFromDancer = authCodeDancer.getContextForResourceOwner("user1");
        Assert.assertThat((Object)authCodeDancer.getContextForResourceOwner("user1"), (Matcher)Matchers.sameInstance((Object)contextFromDancer));
        Assert.assertThat(this.tokensStore.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void authCodeFollowingGetContextDiffernetUser() throws Exception {
        AuthorizationCodeOAuthDancer authCodeDancer = (AuthorizationCodeOAuthDancer)this.baseAuthCodeDancerbuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        ResourceOwnerOAuthContext contextFromDancer1 = authCodeDancer.getContextForResourceOwner("user1");
        ResourceOwnerOAuthContext contextFromDancer2 = authCodeDancer.getContextForResourceOwner("user2");
        Assert.assertThat((Object)authCodeDancer.getContextForResourceOwner("user1"), (Matcher)Matchers.sameInstance((Object)contextFromDancer1));
        Assert.assertThat((Object)authCodeDancer.getContextForResourceOwner("user2"), (Matcher)Matchers.sameInstance((Object)contextFromDancer2));
        Assert.assertThat((Object)contextFromDancer1, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)contextFromDancer2)));
        Assert.assertThat(this.tokensStore.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void authCodeInvalidateContext() throws Exception {
        AuthorizationCodeOAuthDancer authCodeDancer = (AuthorizationCodeOAuthDancer)this.baseAuthCodeDancerbuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"user1")));
        authCodeDancer.getContextForResourceOwner("user1");
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasKey((Object)"user1"));
        authCodeDancer.invalidateContext("user1");
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"user1")));
    }

    @Test
    @Issue(value="W-15154658")
    public void authCodeInvalidateContextWithCluster() throws Exception {
        AuthorizationCodeOAuthDancer authCodeDancer = (AuthorizationCodeOAuthDancer)this.baseAuthCodeDancerbuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"user1")));
        authCodeDancer.getContextForResourceOwner("user1");
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasKey((Object)"user1"));
        int oldTokensStoreSize = this.tokensStore.size();
        authCodeDancer.invalidateContext("user1", true);
        Assert.assertThat((Object)this.tokensStore.size(), (Matcher)Matchers.is((Object)oldTokensStoreSize));
        authCodeDancer.invalidateContext("user1", false);
        Assert.assertThat((Object)this.tokensStore.size(), (Matcher)Matchers.is((Object)(oldTokensStoreSize - 1)));
    }

    @Test
    public void authCodeInvalidateContextDoesNotAffectOtherUsers() throws Exception {
        AuthorizationCodeOAuthDancer authCodeDancer = (AuthorizationCodeOAuthDancer)this.baseAuthCodeDancerbuilder().tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token").build();
        authCodeDancer.getContextForResourceOwner("user1");
        authCodeDancer.getContextForResourceOwner("user2");
        Assert.assertThat(this.tokensStore.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasKey((Object)"user1"));
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasKey((Object)"user2"));
        authCodeDancer.invalidateContext("user1");
        Assert.assertThat(this.tokensStore, (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"user1")));
        Assert.assertThat(this.tokensStore, (Matcher)IsMapContaining.hasKey((Object)"user2"));
    }

    @Override
    protected OAuthClientCredentialsDancerBuilder baseClientCredentialsDancerBuilder() {
        DefaultOAuthClientCredentialsDancerBuilder builder = new DefaultOAuthClientCredentialsDancerBuilder((SchedulerService)new SimpleUnitTestSupportSchedulerService(), this.lockFactory, this.tokensStore, this.oAuthHttpClientFactory, (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        builder.clientCredentials("clientId", "clientSecret");
        builder.tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token");
        return builder;
    }

    @Override
    protected OAuthAuthorizationCodeDancerBuilder baseAuthCodeDancerbuilder() {
        DefaultOAuthAuthorizationCodeDancerBuilder builder = new DefaultOAuthAuthorizationCodeDancerBuilder((SchedulerService)new SimpleUnitTestSupportSchedulerService(), this.lockFactory, this.tokensStore, this.httpService, this.oAuthHttpClientFactory, (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        builder.clientCredentials("clientId", "clientSecret");
        builder.tokenUrl((HttpClient)Mockito.mock(HttpClient.class), "http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback((HttpServer)Mockito.mock(HttpServer.class), "localCallback");
        return builder;
    }
}

