/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

/**
 * Provides OAuth authentication client.
 *
 * @moduleGraph
 * @since 2.0
 */
module org.mule.test.oauth.client.impl {

  requires org.mule.runtime.api;
  requires transitive org.mule.runtime.http.api;
  requires org.mule.oauth.client.api;

  requires com.github.benmanes.caffeine;
  requires org.apache.commons.codec;
  requires org.apache.commons.io;
  requires org.apache.commons.lang3;
  requires org.hamcrest;
  requires junit;
  requires org.mockito;
  requires io.qameta.allure.commons;
  requires org.mule.runtime.core;
  requires org.mule.oauth.client.impl;
  requires org.mule.test.unit;

  exports org.mule.runtime.test;
  exports org.mule.runtime.test.oauth;

  // To avoid duplicating the tests just for the coverage of the legacy dancers and builders
  exports org.mule.runtime.test.oauth.internal to
    org.mule.test.service.oauth,
    junit;
  exports org.mule.runtime.test.oauth.state to
    org.mule.test.service.oauth;

}