/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.clientcredentials;

import io.qameta.allure.Story;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.state.DancerState;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.runtime.test.oauth.AbstractOAuthTestCase;

@Story(value="Client credentials")
public class ClientCredentialsTokenTestCase
extends AbstractOAuthTestCase {
    private static final String ALADDIN = "Aladdin";
    private static final String OPEN_SESAME = "openSesame";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void refreshTokenAfterInvalidate() throws Exception {
        HashMap tokensStore = new HashMap();
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder(tokensStore);
        builder.tokenUrl("http://host/token");
        ClientCredentialsOAuthDancer minimalDancer = (ClientCredentialsOAuthDancer)this.startDancer(builder);
        Assert.assertThat(minimalDancer.accessToken().get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        tokensStore.clear();
        Assert.assertThat(minimalDancer.accessToken().get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenOnceAtATime() throws Exception {
        HashMap tokensStore = new HashMap();
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder(tokensStore);
        builder.tokenUrl("http://host/token");
        ClientCredentialsOAuthDancer minimalDancer = (ClientCredentialsOAuthDancer)this.startDancer(builder);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        tokensStore.clear();
        try {
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                futures.add(executor.submit(() -> {
                    try {
                        minimalDancer.refreshToken().get();
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }));
            }
            for (Future future : futures) {
                future.get(50000L, TimeUnit.MILLISECONDS);
            }
            ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpRequestUrlMatcher("http://host/token")), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void refreshTokenOnceAtATimeSequential() throws Exception {
        HashMap tokensStore = new HashMap();
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder(tokensStore);
        builder.tokenUrl("http://host/token");
        ClientCredentialsOAuthDancer minimalDancer = (ClientCredentialsOAuthDancer)this.startDancer(builder);
        tokensStore.clear();
        CompletableFuture refreshToken1 = minimalDancer.refreshToken();
        CompletableFuture refreshToken2 = minimalDancer.refreshToken();
        refreshToken1.get();
        refreshToken2.get();
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).sendAsync((HttpRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpRequestUrlMatcher("http://host/token")), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
    }

    private void assertClientCredentialsEncodedInHeader(boolean useDeprecatedMethod) throws Exception {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        builder.clientCredentials(ALADDIN, "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(false);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BASIC_AUTH_HEADER);
        }
        this.startDancer(builder);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderValue("Authorization"), (Matcher)Matchers.is((Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)CLIENT_ID)));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)CLIENT_SECRET)));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=client_credentials"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=open+sesame")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void clientCredentialsEncodedInHeaderCompatibility() throws Exception {
        this.assertClientCredentialsEncodedInHeader(true);
    }

    @Test
    public void clientCredentialsEncodedInHeader() throws Exception {
        this.assertClientCredentialsEncodedInHeader(false);
    }

    @Test
    public void clientCredentialsEncodedInHeaderByDefault() throws Exception {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        builder.clientCredentials(ALADDIN, "open sesame");
        this.startDancer(builder);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderValue("Authorization"), (Matcher)Matchers.is((Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)CLIENT_ID)));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)CLIENT_SECRET)));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=client_credentials"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=open+sesame")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    private void assertClientCredentialsInBody(boolean useDeprecatedMethod) throws Exception {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        builder.clientCredentials(ALADDIN, "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(true);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BODY);
        }
        this.startDancer(builder);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)CLIENT_ID)));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)CLIENT_SECRET)));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=client_credentials"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
    }

    @Test
    public void clientCredentialsInBodyCompatibility() throws Exception {
        this.assertClientCredentialsInBody(true);
    }

    @Test
    public void clientCredentialsInBody() throws Exception {
        this.assertClientCredentialsInBody(false);
    }

    @Test
    public void clientCredentialsInQueryParams() throws Exception {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        builder.clientCredentials(ALADDIN, OPEN_SESAME);
        builder.withClientCredentialsIn(ClientCredentialsLocation.QUERY_PARAMS);
        this.startDancer(builder);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)CLIENT_ID), (Matcher)Matchers.is((Object)ALADDIN));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)CLIENT_SECRET), (Matcher)Matchers.is((Object)OPEN_SESAME));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=client_credentials"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void clientCredentialsWithCustomQueryParams() throws Exception {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        builder.clientCredentials(ALADDIN, OPEN_SESAME);
        builder.withClientCredentialsIn(ClientCredentialsLocation.QUERY_PARAMS);
        MultiMap queryParams = new MultiMap();
        String daenerys = "Daenerys";
        Object[] daenerysValues = new String[]{"First of her name", "Mother of Dragons", "Mad Queen"};
        String jonSnow = "Jon Snow";
        Object[] snowValues = new String[]{"Commander of the Night Watch", "Looser"};
        Stream.of(daenerysValues).forEach(v -> {
            String cfr_ignored_0 = (String)queryParams.put((Object)"Daenerys", v);
        });
        Stream.of(snowValues).forEach(v -> {
            String cfr_ignored_0 = (String)queryParams.put((Object)"Jon Snow", v);
        });
        builder.customParameters((Map)queryParams);
        this.startDancer(builder);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        HttpRequest request = (HttpRequest)requestCaptor.getValue();
        Assert.assertThat((Object)request.getQueryParams().getAll((Object)"Daenerys"), (Matcher)Matchers.containsInAnyOrder((Object[])daenerysValues));
        Assert.assertThat((Object)request.getQueryParams().getAll((Object)"Jon Snow"), (Matcher)Matchers.containsInAnyOrder((Object[])snowValues));
    }

    @Test
    public void clientCredentialsWithCustomHeaders() throws Exception {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        builder.clientCredentials(ALADDIN, OPEN_SESAME);
        builder.withClientCredentialsIn(ClientCredentialsLocation.QUERY_PARAMS);
        MultiMap customHeaders = new MultiMap();
        String daenerys = "Daenerys";
        Object[] daenerysValues = new String[]{"First of her name", "Mother of Dragons", "Mad Queen"};
        String jonSnow = "Jon Snow";
        Object[] snowValues = new String[]{"Commander of the Night Watch", "Looser"};
        Stream.of(daenerysValues).forEach(v -> {
            String cfr_ignored_0 = (String)customHeaders.put((Object)"Daenerys", v);
        });
        Stream.of(snowValues).forEach(v -> {
            String cfr_ignored_0 = (String)customHeaders.put((Object)"Jon Snow", v);
        });
        builder.customHeaders((Map)customHeaders);
        this.startDancer(builder);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        HttpRequest request = (HttpRequest)requestCaptor.getValue();
        Assert.assertThat((Object)request.getHeaders().getAll((Object)"Daenerys"), (Matcher)Matchers.containsInAnyOrder((Object[])daenerysValues));
        Assert.assertThat((Object)request.getHeaders().getAll((Object)"Jon Snow"), (Matcher)Matchers.containsInAnyOrder((Object[])snowValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionOnTokenRequest() throws Exception {
        IllegalStateException thrown = new IllegalStateException();
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{thrown});
        HashMap tokensStore = new HashMap();
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder(tokensStore);
        builder.tokenUrl("http://host/token");
        this.expected.expect(Matchers.sameInstance((Object)thrown));
        try {
            this.startDancer(builder);
        }
        finally {
            Assert.assertThat((Object)((ResourceOwnerOAuthContextWithRefreshState)tokensStore.get("default")).getDancerState(), (Matcher)Matchers.is((Object)DancerState.NO_TOKEN));
            Assert.assertThat((Object)((ResourceOwnerOAuthContextWithRefreshState)tokensStore.get("default")).getAccessToken(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionOnTokenRequestWithPreviouslyStoredToken() throws Exception {
        IllegalStateException thrown = new IllegalStateException();
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{thrown});
        HashMap<String, ResourceOwnerOAuthContextWithRefreshState> tokensStore = new HashMap<String, ResourceOwnerOAuthContextWithRefreshState>();
        ResourceOwnerOAuthContextWithRefreshState previousState = new ResourceOwnerOAuthContextWithRefreshState("default");
        previousState.setAccessToken("PreviousToken");
        previousState.setDancerState(DancerState.HAS_TOKEN);
        tokensStore.put("default", previousState);
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder(tokensStore);
        builder.tokenUrl("http://host/token");
        this.expected.expect(Matchers.sameInstance((Object)thrown));
        try {
            this.startDancer(builder);
        }
        finally {
            Assert.assertThat((Object)((ResourceOwnerOAuthContextWithRefreshState)tokensStore.get("default")).getDancerState(), (Matcher)Matchers.is((Object)DancerState.NO_TOKEN));
            Assert.assertThat((Object)((ResourceOwnerOAuthContextWithRefreshState)tokensStore.get("default")).getAccessToken(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    private static class HttpRequestUrlMatcher
    implements ArgumentMatcher<HttpRequest> {
        private final URI uri = new URI("http://host/token");

        public HttpRequestUrlMatcher(String url) throws URISyntaxException {
        }

        public boolean matches(HttpRequest request) {
            return request.getUri().equals(this.uri);
        }
    }
}

