/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.authorizationcode;

import io.qameta.allure.Story;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.runtime.oauth.internal.builder.DefaultOAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.test.oauth.AbstractOAuthTestCase;
import org.mule.runtime.test.oauth.state.CustomResourceOwnerOAuthContext;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Story(value="Authorization Code")
public class AuthorizationCodeTokenTestCase
extends AbstractOAuthTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationCodeTokenTestCase.class);
    private final ArgumentCaptor<RequestHandler> localCallbackCaptor = ArgumentCaptor.forClass(RequestHandler.class);
    private AuthorizationCodeOAuthDancer minimalDancer;
    private final Supplier<ResourceOwnerOAuthContext> contextSupplier;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> {
            CustomResourceOwnerOAuthContext context = new CustomResourceOwnerOAuthContext(new ReentrantLock(), "default");
            context.setRefreshToken("refreshToken");
            return context;
        }}, {() -> {
            ResourceOwnerOAuthContextWithRefreshState context = new ResourceOwnerOAuthContextWithRefreshState("default");
            context.setRefreshToken("refreshToken");
            return context;
        }});
    }

    public AuthorizationCodeTokenTestCase(Supplier<ResourceOwnerOAuthContext> contextSupplier) {
        this.contextSupplier = contextSupplier;
    }

    @Before
    public void before() {
        Mockito.when((Object)this.httpServer.addRequestHandler((Collection)ArgumentMatchers.eq(Collections.singleton(HttpConstants.Method.GET.name())), (String)ArgumentMatchers.eq((Object)"/localCallback"), (RequestHandler)this.localCallbackCaptor.capture())).thenReturn(Mockito.mock(RequestHandlerManager.class));
        Mockito.when((Object)this.httpServer.addRequestHandler((Collection)ArgumentMatchers.eq(Collections.singleton(HttpConstants.Method.GET.name())), (String)ArgumentMatchers.eq((Object)"/auth"), (RequestHandler)ArgumentMatchers.any(RequestHandler.class))).thenReturn(Mockito.mock(RequestHandlerManager.class));
    }

    @After
    public void after() throws MuleException {
        if (this.minimalDancer != null) {
            LifecycleUtils.stopIfNeeded((Object)this.minimalDancer);
            LifecycleUtils.disposeIfNeeded((Object)this.minimalDancer, (Logger)LOGGER);
        }
    }

    private void assertAuthCodeCredentialsEncodedInHeader(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(false);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BASIC_AUTH_HEADER);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderValue("Authorization"), (Matcher)Matchers.is((Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=open+sesame")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeCredentialsEncodedInHeader() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeader(false);
    }

    @Test
    public void authCodeCredentialsEncodedInHeaderCompatibility() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeader(true);
    }

    @Test
    public void authCodeCredentialsInBodyByDefault() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
    }

    private void assertAuthCodeCredentialsInBody(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(true);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BODY);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
    }

    @Test
    public void authCodeCredentialsInBodyCompatibility() throws Exception {
        this.assertAuthCodeCredentialsInBody(true);
    }

    @Test
    public void authCodeCredentialsInBody() throws Exception {
        this.assertAuthCodeCredentialsInBody(false);
    }

    protected HttpRequestContext buildLocalCallbackRequestContext() {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"code", (Object)"authCode");
        Mockito.when((Object)request.getQueryParams()).thenReturn((Object)queryParams);
        HttpRequestContext requestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)requestContext.getRequest()).thenReturn((Object)request);
        return requestContext;
    }

    private void assertAuthCodeCredentialsEncodedInHeaderRefresh(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(false);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BASIC_AUTH_HEADER);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderValue("Authorization"), (Matcher)Matchers.is((Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=refresh_token"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=open+sesame")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeCredentialsEncodedInHeaderRefreshCompatibility() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeaderRefresh(true);
    }

    @Test
    public void authCodeCredentialsEncodedInHeaderRefresh() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeaderRefresh(false);
    }

    @Test
    public void authCodeCredentialsInBodyRefreshByDefault() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=refresh_token"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
    }

    private void assertAuthCodeCredentialsInBodyRefresh(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(true);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BODY);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=refresh_token"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
    }

    @Test
    public void authCodeCredentialsInBodyRefreshCompatibility() throws Exception {
        this.assertAuthCodeCredentialsInBodyRefresh(true);
    }

    @Test
    public void authCodeCredentialsInBodyRefresh() throws Exception {
        this.assertAuthCodeCredentialsInBodyRefresh(false);
    }

    @Test
    public void authCodeRefreshTokenWithQueryParams() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null, true);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id"), (Matcher)Matchers.is((Object)"Aladdin"));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret"), (Matcher)Matchers.is((Object)"openSesame"));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"grant_type"), (Matcher)Matchers.is((Object)"refresh_token"));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"refresh_token"), (Matcher)Matchers.is((Object)"refreshToken"));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"grant_type=refresh_token")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"refresh_token=")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeCredentialsAsQueryParams() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        builder.withClientCredentialsIn(ClientCredentialsLocation.QUERY_PARAMS);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id"), (Matcher)Matchers.is((Object)"Aladdin"));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret"), (Matcher)Matchers.is((Object)"openSesame"));
        Assert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        Assert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Override
    protected OAuthAuthorizationCodeDancerBuilder baseAuthCodeDancerbuilder() {
        ResourceOwnerOAuthContext context = this.contextSupplier.get();
        HashMap<String, ResourceOwnerOAuthContext> tokensMap = new HashMap<String, ResourceOwnerOAuthContext>();
        tokensMap.put("default", context);
        DefaultOAuthAuthorizationCodeDancerBuilder builder = new DefaultOAuthAuthorizationCodeDancerBuilder((SchedulerService)new SimpleUnitTestSupportSchedulerService(), this.lockFactory, tokensMap, this.httpService, this.oAuthHttpClientFactory, (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        builder.clientCredentials("clientId", "clientSecret");
        return builder;
    }
}

