/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.oauth.internal.config;

/**
 * A set of common attributes to all grant-types dancer token parser.
 *
 * @since 1.0
 */
public class TokenParserConfig {

  private String responseAccessTokenExpr;
  private String responseRefreshTokenExpr;
  private String responseExpiresInExpr;

  public TokenParserConfig(String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr) {
    this.responseAccessTokenExpr = responseAccessTokenExpr;
    this.responseRefreshTokenExpr = responseRefreshTokenExpr;
    this.responseExpiresInExpr = responseExpiresInExpr;
  }

  public String getResponseAccessTokenExpr() {
    return responseAccessTokenExpr;
  }

  public void setResponseAccessTokenExpr(String responseAccessTokenExpr) {
    this.responseAccessTokenExpr = responseAccessTokenExpr;
  }

  public String getResponseRefreshTokenExpr() {
    return responseRefreshTokenExpr;
  }

  public void setResponseRefreshTokenExpr(String responseRefreshTokenExpr) {
    this.responseRefreshTokenExpr = responseRefreshTokenExpr;
  }

  public String getResponseExpiresInExpr() {
    return responseExpiresInExpr;
  }

  public void setResponseExpiresInExpr(String responseExpiresInExpr) {
    this.responseExpiresInExpr = responseExpiresInExpr;
  }

  public static Builder builder() {
    return new Builder();
  }

  /**
   * Builder implementation for creating a {@link TokenParserConfig} instance
   *
   * @since 1.0
   */
  public static class Builder {

    private String responseAccessTokenExpr;
    private String responseRefreshTokenExpr;
    private String responseExpiresInExpr;

    private Builder() {}

    public Builder withResponseAccessTokenExpr(String responseAccessTokenExpr) {
      this.responseAccessTokenExpr = responseAccessTokenExpr;
      return this;
    }

    public Builder withResponseRefreshTokenExpr(String responseRefreshTokenExpr) {
      this.responseRefreshTokenExpr = responseRefreshTokenExpr;
      return this;
    }

    public Builder withResponseExpiresInExpr(String responseExpiresInExpr) {
      this.responseExpiresInExpr = responseExpiresInExpr;
      return this;
    }

    public TokenParserConfig build() {
      return new TokenParserConfig(responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr);
    }
  }
}
