/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.json.JSONException;
import org.json.JSONObject;
import org.mule.common.metadata.parser.json.AbstractType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.SchemaEnv;
import org.mule.common.metadata.parser.json.SchemaException;

public class JSONFileType
extends AbstractType {
    private File file;
    private JSONType fileType;
    private SchemaEnv env;

    public JSONFileType(SchemaEnv env, File f) {
        this.env = env;
        this.file = f;
        this.fileType = null;
    }

    public void loadType(File f) {
        try {
            FileReader reader = new FileReader(f);
            try {
                this.loadType(reader);
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.file.getName(), e);
        }
    }

    public void loadType(Reader reader) {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        int read = -1;
        try {
            while ((read = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, read);
            }
            String jsonString = builder.toString();
            JSONObject obj = new JSONObject(jsonString);
            this.fileType = new JSONObjectType(this.env, obj);
        }
        catch (IOException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.file.getName(), e);
        }
        catch (JSONException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.file.getName(), e);
        }
        catch (SchemaException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.file.getName(), e);
        }
    }

    public void loadType() {
        this.loadType(this.file);
    }

    @Override
    public boolean contains(Object obj) {
        if (this.fileType == null) {
            this.loadType();
        }
        return this.fileType.contains(obj);
    }

    @Override
    public String explain(Object obj) {
        if (this.fileType == null) {
            this.loadType();
        }
        return this.fileType.explain(obj);
    }

    @Override
    public boolean isJSONPrimitive() {
        return false;
    }

    @Override
    public boolean isJSONArray() {
        return false;
    }

    @Override
    public boolean isJSONObject() {
        return false;
    }

    @Override
    public boolean isJSONPointer() {
        return false;
    }
}

