/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultStructuredMetadataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataFieldFactory;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.parser.json.JSONArrayType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONPointerType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.JSONTypeUtils;

public class JSONSchemaMetaDataFieldFactory
implements MetaDataFieldFactory {
    Map<JSONObjectType, DefaultStructuredMetadataModel> visitedTypes = null;
    private JSONType jsonSchemaType;

    public JSONSchemaMetaDataFieldFactory(JSONObjectType type) {
        this.jsonSchemaType = type;
    }

    public JSONSchemaMetaDataFieldFactory(JSONObjectType type, Map<JSONObjectType, DefaultStructuredMetadataModel> visitedTypesParameter) {
        this(type);
        this.visitedTypes = visitedTypesParameter;
    }

    @Override
    public List<MetaDataField> createFields() {
        ArrayList<MetaDataField> metaDataFields = new ArrayList<MetaDataField>();
        if (this.visitedTypes == null) {
            this.visitedTypes = new HashMap<JSONObjectType, DefaultStructuredMetadataModel>();
        }
        this.loadFields((JSONObjectType)this.jsonSchemaType, metaDataFields);
        return metaDataFields;
    }

    private void processJSONSchemaElement(JSONType property, String name, List<MetaDataField> metadata) {
        if (property.isJSONObject()) {
            this.processJSONSchemaObject((JSONObjectType)property, name, metadata);
        } else if (property.isJSONPrimitive()) {
            this.processJSONSchemaPrimitive(property, name, metadata);
        } else if (property.isJSONArray()) {
            this.processJSONSchemaArray((JSONArrayType)property, name, metadata);
        } else if (property.isJSONPointer()) {
            this.processJSONPointer((JSONPointerType)property, name, metadata);
        }
    }

    private void processJSONSchemaObject(JSONObjectType type, String name, List<MetaDataField> metadata) {
        DefaultStructuredMetadataModel model = this.buildJSONMetaDataModel(type);
        metadata.add(new DefaultMetaDataField(name, model));
    }

    private DefaultStructuredMetadataModel buildJSONMetaDataModel(JSONObjectType type) {
        DefaultStructuredMetadataModel model;
        if (this.visitedTypes.containsKey(type)) {
            model = this.visitedTypes.get(type);
        } else {
            model = new DefaultStructuredMetadataModel(DataType.JSON);
            this.visitedTypes.put(type, model);
            model.loadFieldsFrom(new JSONSchemaMetaDataFieldFactory(type, this.visitedTypes));
        }
        return model;
    }

    private void loadFields(JSONObjectType type, List<MetaDataField> metadata) {
        String[] properties;
        for (String key : properties = type.getProperties()) {
            JSONType propertyType = type.getPropertyType(key);
            this.processJSONSchemaElement(propertyType, key, metadata);
        }
    }

    private void processJSONSchemaArray(JSONArrayType property, String name, List<MetaDataField> metadata) {
        AbstractMetaDataModel model = this.buildJSONArrayMetaDataModel(property);
        metadata.add(new DefaultMetaDataField(name, new DefaultListMetaDataModel(model)));
    }

    private AbstractMetaDataModel buildJSONArrayMetaDataModel(JSONArrayType property) {
        AbstractMetaDataModel model = null;
        JSONType itemsType = property.getItemsType();
        if (itemsType.isJSONPrimitive()) {
            DataType dataType = this.getDataType(itemsType);
            model = dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
        } else if (itemsType.isJSONPointer()) {
            model = this.buildJSONPointerMetaDataModel((JSONPointerType)itemsType);
        } else if (itemsType.isJSONObject()) {
            model = this.buildJSONMetaDataModel((JSONObjectType)itemsType);
        }
        return model;
    }

    private AbstractMetaDataModel buildJSONPointerMetaDataModel(JSONPointerType pointer) {
        JSONType resolvedType = pointer.resolve();
        if (resolvedType.isJSONArray()) {
            return this.buildJSONArrayMetaDataModel((JSONArrayType)resolvedType);
        }
        if (resolvedType.isJSONObject()) {
            return this.buildJSONMetaDataModel((JSONObjectType)resolvedType);
        }
        if (resolvedType.isJSONPointer()) {
            return this.buildJSONPointerMetaDataModel((JSONPointerType)resolvedType);
        }
        if (resolvedType.isJSONPrimitive()) {
            DataType dataType = this.getDataType(resolvedType);
            return dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
        }
        return null;
    }

    private void processJSONSchemaPrimitive(JSONType property, String name, List<MetaDataField> metadata) {
        DataType dataType = this.getDataType(property);
        AbstractMetaDataModel model = dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
        metadata.add(new DefaultMetaDataField(name, model));
    }

    private void processJSONPointer(JSONPointerType ptr, String name, List<MetaDataField> metadata) {
        this.processJSONSchemaElement(ptr.resolve(), name, metadata);
    }

    private DataType getDataType(JSONType jsonType) {
        return JSONTypeUtils.getDataType(jsonType);
    }
}

