/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.Arrays;
import java.util.List;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataPropertyManager;
import org.mule.common.metadata.field.property.DefaultFieldPropertyFactory;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;

public class DefaultMetaDataField
implements MetaDataField {
    private String name;
    private MetaDataModel model;
    private MetaDataField.FieldAccessType accessType;
    private MetaDataPropertyManager<MetaDataFieldProperty> metaDataFieldPropertyManager;

    public DefaultMetaDataField(String name, MetaDataModel model) {
        this(name, model, MetaDataField.FieldAccessType.READ_WRITE, new DefaultFieldPropertyFactory().getProperties(null, model));
    }

    public DefaultMetaDataField(String name, MetaDataModel model, MetaDataField.FieldAccessType accessType) {
        this(name, model, accessType, new DefaultFieldPropertyFactory().getProperties(null, model));
    }

    public DefaultMetaDataField(String name, MetaDataModel model, List<MetaDataFieldProperty> fieldProperties) {
        this(name, model, MetaDataField.FieldAccessType.READ_WRITE, fieldProperties);
    }

    public DefaultMetaDataField(String name, MetaDataModel model, MetaDataFieldProperty ... fieldProperties) {
        this(name, model, MetaDataField.FieldAccessType.READ_WRITE, Arrays.asList(fieldProperties));
    }

    public DefaultMetaDataField(String name, MetaDataModel model, MetaDataField.FieldAccessType accessType, List<MetaDataFieldProperty> fieldProperties) {
        this.name = name;
        this.model = model;
        this.accessType = accessType;
        this.metaDataFieldPropertyManager = new MetaDataPropertyManager<MetaDataFieldProperty>(fieldProperties);
    }

    @Override
    public MetaDataField.FieldAccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MetaDataModel getMetaDataModel() {
        return this.model;
    }

    @Override
    public List<MetaDataFieldProperty> getProperties() {
        return this.metaDataFieldPropertyManager.getProperties();
    }

    @Override
    public boolean addProperty(MetaDataFieldProperty metaDataFieldProperty) {
        return this.metaDataFieldPropertyManager.addProperty(metaDataFieldProperty);
    }

    @Override
    public boolean removeProperty(MetaDataFieldProperty metaDataFieldProperty) {
        return this.metaDataFieldPropertyManager.removeProperty(metaDataFieldProperty);
    }

    @Override
    public boolean hasProperty(Class<? extends MetaDataFieldProperty> metaDataFieldProperty) {
        return this.metaDataFieldPropertyManager.hasProperty(metaDataFieldProperty);
    }

    @Override
    public <T extends MetaDataFieldProperty> T getProperty(Class<T> metaDataFieldProperty) {
        return (T)((MetaDataFieldProperty)this.metaDataFieldPropertyManager.getProperty(metaDataFieldProperty));
    }

    public String toString() {
        return "DefaultMetaDataField [name=" + this.name + ", model=" + this.model.getClass() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultMetaDataField other = (DefaultMetaDataField)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

