/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataProperties;
import org.mule.common.metadata.MetaDataPropertyScope;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;

public class DefaultMetaData
implements MetaData {
    private MetaDataModel payload;
    private Map<MetaDataPropertyScope, MetaDataProperties> properties;

    public DefaultMetaData(MetaDataModel payload) {
        this.payload = payload;
        this.properties = new HashMap<MetaDataPropertyScope, MetaDataProperties>();
        this.initProperties();
    }

    public DefaultMetaData(MetaData oldMetadata, MetaDataModel payload) {
        this(payload);
        for (MetaDataPropertyScope value : MetaDataPropertyScope.values()) {
            this.copyAllPropertiesWithScope(oldMetadata, value);
        }
    }

    public void copyAllPropertiesWithScope(MetaData oldMetadata, MetaDataPropertyScope propertyScope) {
        this.doGetProperties(propertyScope).addAll(oldMetadata.getProperties(propertyScope));
    }

    private void initProperties() {
        MetaDataPropertyScope[] values;
        for (MetaDataPropertyScope value : values = MetaDataPropertyScope.values()) {
            this.getProperties().put(value, new MetaDataProperties());
        }
    }

    @Override
    public MetaDataModel getPayload() {
        return this.payload;
    }

    @Override
    public MetaDataProperties getProperties(MetaDataPropertyScope scope) {
        return this.doGetProperties(scope);
    }

    @Override
    public void addProperty(MetaDataPropertyScope scope, String name, MetaDataModel propertyModel, MetaDataFieldProperty ... properties) {
        this.doGetProperties(scope).add(new DefaultMetaDataField(name, propertyModel, Arrays.asList(properties)));
    }

    @Override
    public void removeProperty(MetaDataPropertyScope scope, String name) {
        this.doGetProperties(scope).removeFieldByName(name);
    }

    private MetaDataProperties doGetProperties(MetaDataPropertyScope scope) {
        MetaDataProperties metaDataProperties = this.getProperties().get((Object)scope);
        if (metaDataProperties == null) {
            metaDataProperties = new MetaDataProperties();
            this.getProperties().put(scope, metaDataProperties);
        }
        return metaDataProperties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultMetaData)) {
            return false;
        }
        DefaultMetaData other = (DefaultMetaData)obj;
        return !(this.payload == null ? other.payload != null : !this.payload.equals(other.payload));
    }

    public String toString() {
        return "DefaultMetaData: { payload: " + (this.payload != null ? this.payload.toString() : "null") + " }";
    }

    private Map<MetaDataPropertyScope, MetaDataProperties> getProperties() {
        if (this.properties == null) {
            this.initProperties();
        }
        return this.properties;
    }
}

