/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.query;

import java.util.ArrayList;
import java.util.List;
import org.mule.common.query.Field;
import org.mule.common.query.Query;
import org.mule.common.query.QueryVisitor;
import org.mule.common.query.Type;
import org.mule.common.query.expression.Direction;
import org.mule.common.query.expression.EmptyExpression;
import org.mule.common.query.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsqlQuery
implements Query {
    protected List<Type> types = new ArrayList<Type>();
    protected List<Field> fields = new ArrayList<Field>();
    protected List<Field> orderByFields = new ArrayList<Field>();
    protected Direction direction = Direction.ASC;
    protected Expression filterExpression = new EmptyExpression();
    protected Expression joinExpression = new EmptyExpression();
    protected int limit = -1;
    protected int offset = -1;

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Field> getOrderByFields() {
        return this.orderByFields;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public Expression getJoinExpression() {
        return this.joinExpression;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void addType(Type type) {
        this.types.add(type);
    }

    @Override
    public void addField(Field field) {
        this.fields.add(field);
    }

    @Override
    public void addOrderField(Field orderByField) {
        this.orderByFields.add(orderByField);
    }

    @Override
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public void setFilterExpression(Expression filterExpression) {
        this.filterExpression = filterExpression;
    }

    @Override
    public void setJoinExpression(Expression joinExpression) {
        this.joinExpression = joinExpression;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void accept(QueryVisitor queryVisitor) {
        queryVisitor.visitTypes(this.types);
        queryVisitor.visitFields(this.fields);
        if (!(this.filterExpression instanceof EmptyExpression)) {
            queryVisitor.visitBeginExpression();
            this.filterExpression.accept(queryVisitor);
        }
        if (this.orderByFields.size() > 0) {
            queryVisitor.visitOrderByFields(this.orderByFields, this.direction);
        }
        if (this.limit != -1) {
            queryVisitor.visitLimit(this.limit);
        }
        if (this.offset != -1) {
            queryVisitor.visitOffset(this.offset);
        }
    }

    @Override
    public boolean hasDirection() {
        return this.direction != null;
    }
}

