/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.field.property;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.common.metadata.field.property.exception.RepeatedFieldPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataFieldPropertyManager {
    private List<MetaDataFieldProperty> fieldProperties;

    public MetaDataFieldPropertyManager(List<MetaDataFieldProperty> fieldProperties) {
        this.setFieldProperties(fieldProperties);
    }

    public boolean hasProperty(Class<? extends MetaDataFieldProperty> fieldProperty) {
        return this.getProperty(fieldProperty) != null;
    }

    public <T extends MetaDataFieldProperty> T getProperty(Class<T> fieldPropertyClass) {
        for (MetaDataFieldProperty fc : this.fieldProperties) {
            if (!fieldPropertyClass.equals(fc.getClass())) continue;
            return (T)fc;
        }
        return null;
    }

    public boolean addProperty(MetaDataFieldProperty fieldProperty) {
        if (this.hasProperty(fieldProperty.getClass())) {
            Object alreadyDefinedProperty = this.getProperty(fieldProperty.getClass());
            this.removeProperty((MetaDataFieldProperty)alreadyDefinedProperty);
        }
        return this.fieldProperties.add(fieldProperty);
    }

    public boolean removeProperty(MetaDataFieldProperty FieldProperty) {
        if (this.fieldProperties.contains(FieldProperty)) {
            return this.fieldProperties.remove(FieldProperty);
        }
        return false;
    }

    public List<MetaDataFieldProperty> getProperties() {
        return Collections.unmodifiableList(this.fieldProperties);
    }

    private void setFieldProperties(List<MetaDataFieldProperty> fieldProperties) {
        if (this.hasRepeatedFieldProperties(fieldProperties)) {
            throw new RepeatedFieldPropertyException("Field capabilities must no be repeated");
        }
        this.fieldProperties = fieldProperties;
    }

    private boolean hasRepeatedFieldProperties(List<MetaDataFieldProperty> fieldProperties) {
        HashSet clazzes = new HashSet();
        for (MetaDataFieldProperty fc : fieldProperties) {
            clazzes.add(fc.getClass());
        }
        return clazzes.size() != fieldProperties.size();
    }
}

