/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.datatype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.query.expression.EqualsOperator;
import org.mule.common.query.expression.GreaterOperator;
import org.mule.common.query.expression.GreaterOrEqualsOperator;
import org.mule.common.query.expression.LessOperator;
import org.mule.common.query.expression.LessOrEqualsOperator;
import org.mule.common.query.expression.LikeOperator;
import org.mule.common.query.expression.NotEqualsOperator;
import org.mule.common.query.expression.Operator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedOperatorsFactory {
    private static SupportedOperatorsFactory instance = new SupportedOperatorsFactory();

    private SupportedOperatorsFactory() {
    }

    public static SupportedOperatorsFactory getInstance() {
        return instance;
    }

    public List<Operator> getSupportedOperationsFor(DataType dataType) {
        switch (dataType) {
            case BOOLEAN: 
            case ENUM: {
                return Arrays.asList(new EqualsOperator(), new NotEqualsOperator());
            }
            case DATE_TIME: 
            case DATE: 
            case BYTE: 
            case NUMBER: 
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case DECIMAL: {
                return this.getCommonOperations();
            }
            case STRING: {
                List<Operator> operators = this.getCommonOperations();
                operators.add(new LikeOperator());
                return operators;
            }
        }
        return new ArrayList<Operator>();
    }

    public List<Operator> getCommonOperations() {
        ArrayList<Operator> operators = new ArrayList<Operator>();
        operators.add(new LessOperator());
        operators.add(new LessOrEqualsOperator());
        operators.add(new EqualsOperator());
        operators.add(new GreaterOperator());
        operators.add(new GreaterOrEqualsOperator());
        operators.add(new NotEqualsOperator());
        return operators;
    }
}

