/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.mule.common.metadata.DefaultXmlMetaDataModel;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.builder.MetaDataBuilder;
import org.mule.common.metadata.builder.XmlMetaDataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmlMetaDataBuilder<P extends MetaDataBuilder<?>>
implements XmlMetaDataBuilder<P> {
    public String name;
    public String[] schemas;
    public InputStream[] schemasStream;
    public Charset encoding = Charset.forName("UTF-8");

    public DefaultXmlMetaDataBuilder(String name) {
        this.name = name;
    }

    @Override
    public XmlMetaDataModel build() {
        DefaultXmlMetaDataModel model = null;
        if (this.schemas != null) {
            model = new DefaultXmlMetaDataModel(Arrays.asList(this.schemas), this.name, this.encoding);
        } else if (this.schemasStream != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (InputStream schemaStream : this.schemasStream) {
                result.add(DefaultXmlMetaDataBuilder.getStringFromInputStream(schemaStream, this.encoding));
            }
            model = new DefaultXmlMetaDataModel(result, this.name, this.encoding);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream is, Charset encoding) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, encoding));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> addSchemaStringList(String ... schemas) {
        this.schemas = schemas;
        this.schemasStream = null;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> addSchemaStreamList(InputStream ... schemaStreams) {
        this.schemasStream = schemaStreams;
        this.schemas = null;
        return this;
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> setEncoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }
}

