/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model.api;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.apikit.common.ApiVendorUtils;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.ApiFormat;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.api.ApiSyncApiRef;
import org.mule.apikit.model.api.DefaultApiRef;
import org.mule.apikit.model.api.URIApiRef;

public interface ApiReference {
    public static ApiReference create(String location, ResourceLoader resourceLoader) {
        if (ApiSyncUtils.isSyncProtocol(location)) {
            return resourceLoader != null ? new ApiSyncApiRef(location, resourceLoader) : new ApiSyncApiRef(location);
        }
        try {
            URI uri = new URI(location);
            if (uri.isAbsolute()) {
                return new URIApiRef(uri, resourceLoader);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new DefaultApiRef(location, resourceLoader);
    }

    public static ApiReference create(String location) {
        return ApiReference.create(location, null);
    }

    public static ApiReference create(URI uri) {
        return new URIApiRef(uri);
    }

    public String getLocation();

    public String getFormat();

    public InputStream resolve();

    public Optional<ResourceLoader> getResourceLoader();

    default public ApiVendor getVendor() {
        String format = this.getFormat();
        if (ApiFormat.RAML.name().equalsIgnoreCase(format)) {
            ApiVendor ramlVendor = ApiVendorUtils.getRamlVendor(this.resolve());
            return ramlVendor != null ? ramlVendor : ApiVendor.RAML_10;
        }
        return ApiVendorUtils.deduceApiVendor(this.resolve());
    }

    default public URI getPathAsUri() {
        URI uri;
        try {
            URI uri2 = new URI(this.getLocation());
            if (uri2.isAbsolute()) {
                return uri2;
            }
        }
        catch (URISyntaxException uri2) {
            // empty catch block
        }
        String location = this.getLocation();
        if (this.getResourceLoader().isPresent() && (uri = (URI)this.getResourceLoader().map(loader -> loader.getResource(location)).orElse(null)) != null) {
            return uri;
        }
        File file = new File(location);
        if (file.exists()) {
            return file.toURI();
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(location);
        if (resource != null) {
            try {
                return resource.toURI();
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException("Couldn't load api in location: " + location);
            }
        }
        throw new RuntimeException("Couldn't load api in location: " + location);
    }
}

