/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.loader;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;

public class ProvidedResourceLoader
implements ResourceLoader {
    private org.mule.apikit.loader.ResourceLoader resourceLoader;

    public ProvidedResourceLoader(org.mule.apikit.loader.ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public CompletableFuture<Content> fetch(String resourceName) {
        CompletableFuture<Content> future = new CompletableFuture<Content>();
        if (resourceName == null || resourceName.isEmpty()) {
            throw new RuntimeException("Failed to apply.");
        }
        try {
            InputStream streamResource = this.getResourceFromURI(resourceName);
            if (streamResource != null) {
                future.complete(new Content(this.getContentFromStream(streamResource), resourceName));
                return future;
            }
            URI resourceUri = this.resourceLoader.getResource(resourceName);
            if (resourceUri != null) {
                streamResource = this.resourceLoader.getResourceAsStream(resourceName);
                future.complete(new Content(this.getContentFromStream(streamResource), resourceUri.toString()));
                return future;
            }
            future.completeExceptionally(new Exception("Failed to fetch resource '" + resourceName + "'"));
            return future;
        }
        catch (Exception e) {
            future.completeExceptionally(new RuntimeException("Failed to fetch resource '" + resourceName + "'", e));
            return future;
        }
    }

    private String getContentFromStream(InputStream stream) {
        try {
            return IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isValidUri(String resourceName) {
        try {
            new URI(resourceName);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private InputStream getResourceFromURI(String resourceName) {
        try {
            if (!this.isValidUri(resourceName)) {
                return null;
            }
            URL url = new URI(resourceName).toURL();
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            return urlConnection.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }
}

